<?php

// helpers.php

// Asegura que ROOT_PATH exista por si se incluye desde otro sitio
if (!defined('ROOT_PATH')) {
    define('ROOT_PATH', dirname(__DIR__)); 
}

/**
 * Construye una URL completa usando la constante BASE_URL definida en index.php.
 * @param string $path La ruta interna (ej: 'admin/settings').
 * @return string La URL absoluta correcta (ej: /romarqtech_backend/admin/settings).
 */
function url(string $path = ''): string {
    // Quita las barras de los extremos para evitar // o rutas rotas
    $baseUrl = rtrim(BASE_URL, '/');
    $path = ltrim($path, '/');
    
    return $baseUrl . '/' . $path;
}

/**
 * Redirige al usuario a una URL interna.
 */
function redirect(string $path = ''): void {
    $finalUrl = url($path);
    if (!headers_sent()) {
        header('Location: ' . $finalUrl);
        exit();
    } else {
        die("Error: No se puede redirigir. Las cabeceras ya fueron enviadas a: " . htmlspecialchars($finalUrl));
    }
}