-- database/seed.sql

-- Data for site_metadata
INSERT INTO site_metadata (company_name, site_title, site_title_template, site_description, site_url, site_logo, site_logo_rq, site_logo_square, email, phone, whatsapp_number, address, social, location, keywords, hiring_contact_name, hiring_contact_email, hiring_contact_whatsapp_message) VALUES (
    'ROMARQTECH',
    'ROMARQTECH — Desarrollo de Software y Soluciones Digitales a Medida',
    '{title} | ROMARQTECH',
    'Transformamos ideas en productos digitales de alto impacto. Creamos software a medida, aplicaciones móviles y soluciones web que optimizan procesos e impulsan el crecimiento.',
    'https://www.romarqtech.com',
    '/images/logo-romarqtech.png',
    '/logo/logo-romarqtech.png',
    '/images/logo-square-romarqtech.png',
    'contacto@romarqtech.com',
    '+51 962 323 163',
    '51962323163',
    'Av. Javier Prado Este 42, San Isidro, Lima, Perú',
    '{"linkedin": "https://www.linkedin.com/company/romarqtech", "github": "https://github.com/romarqtech", "twitter": "https://twitter.com/romarqtech"}',
    '{"latitude": "-12.0883", "longitude": "-77.0333"}',
    'desarrollo de software, aplicaciones móviles, perú, lima, software a medida, erp, crm, e-commerce, romarqtech',
    'RRHH ROMARQTECH',
    'talento@romarqtech.com',
    'Hola ROMARQTECH, quiero información sobre procesos de selección.'
);

-- Data for navigation
INSERT INTO navigation (name, href, `order`) VALUES
('Inicio', '/', 1),
('Nosotros', '/nosotros', 2),
('Servicios', '/servicios', 3),
('Proyectos', '/proyectos', 4),
('Brochure', '/brochure', 5),
('Contacto', '/contacto', 6);

-- Data for pages
INSERT INTO pages (page_key, seo_title, seo_description, hero_headline, hero_subheadline, hero_cta_primary_text, hero_cta_primary_href, hero_cta_secondary_text, hero_cta_secondary_href, mission, vision, timeline, team, stats) VALUES (
    'home',
    'Desarrollo de Software y Soluciones Digitales a Medida',
    'Creamos software a medida, aplicaciones móviles y soluciones web que optimizan procesos, impulsan el crecimiento y ofrecen experiencias de usuario excepcionales.',
    'Transformamos Ideas en Productos Digitales de Alto Impacto',
    'Creamos software a medida, aplicaciones móviles y soluciones web que optimizan procesos, impulsan el crecimiento y ofrecen experiencias de usuario excepcionales.',
    'Solicitar Propuesta',
    '/contacto',
    'Ver Proyectos',
    '/proyectos',
    NULL, NULL, NULL, NULL, 
    '[{"label": "Proyectos", "value": 150, "suffix": "+"}, {"label": "Años Experiencia", "value": 10, "suffix": "+"}, {"label": "Satisfacción", "value": 99, "suffix": "%"}]
);

INSERT INTO pages (page_key, seo_title, seo_description, hero_headline, hero_subheadline, hero_cta_primary_text, hero_cta_primary_href, hero_cta_secondary_text, hero_cta_secondary_href, mission, vision, timeline, team, stats) VALUES (
    'about',
    'Sobre Nosotros',
    'Conoce al equipo de ROMARQTECH, nuestra misión, visión y los valores que nos impulsan a crear soluciones tecnológicas de primer nivel.',
    NULL, NULL, NULL, NULL, NULL, NULL,
    'Nuestra misión es ser el socio tecnológico estratégico que impulsa la transformación digital de las empresas, creando soluciones de software robustas, escalables y centradas en el usuario que generan un valor medible y sostenible.',
    'Ser la empresa líder en desarrollo de software a medida en Latinoamérica, reconocida por nuestra innovación, calidad y el compromiso con el éxito de nuestros clientes.',
    '[{"title": "Fundación 2015", "desc": "Iniciamos como consultora para pymes.", "date": "2015"}, {"title": "Primer producto", "desc": "Lanzamos soluciones ERP verticales.", "date": "2018"}, {"title": "Expansión", "desc": "E-commerce y logística: nuevos verticales.", "date": "2022"}]',
    '[{"name": "Romario Quispe", "role": "CEO & Arquitecto de Software", "image": "/images/team/romario-quispe.jpg", "bio": "Líder del equipo con más de 10 años de experiencia creando soluciones de software escalables y de alto impacto para diversas industrias.", "social": {"linkedin": "https://linkedin.com/in/romario-quispe", "github": "https://github.com/romario-quispe"}}, {"name": "Ana García", "role": "Diseñadora UI/UX Senior", "image": "/images/team/ana-garcia.jpg", "bio": "Especialista en crear interfaces intuitivas y atractivas, enfocada en la experiencia del usuario final para garantizar la máxima usabilidad.", "social": {"linkedin": "https://linkedin.com/in/ana-garcia", "dribbble": "https://dribbble.com/ana-garcia"}}, {"name": "Carlos Vega", "role": "Desarrollador Backend Senior", "image": "/images/team/carlos-vega.jpg", "bio": "Experto en la construcción de APIs robustas y seguras, gestión de bases de datos y la arquitectura del lado del servidor que impulsa nuestras aplicaciones.", "social": {"linkedin": "https://linkedin.com/in/carlos-vega", "github": "https://github.com/carlos-vega"}}, {"name": "Laura Méndez", "role": "Desarrolladora Frontend", "image": "/images/team/laura-mendez.jpg", "bio": "Apasionada por dar vida a los diseños. Domina las últimas tecnologías web para construir interfaces rápidas, responsivas y dinámicas.", "social": {"linkedin": "https://linkedin.com/in/laura-mendez", "github": "https://github.com/laura-mendez"}}]',
    NULL
);

-- Data for services
INSERT INTO services (id, seo_title, seo_description, title, icon, image, video, short_description, detailed_description, key_offerings, cta_text, cta_whatsapp_message) VALUES
('desarrollo-web', 'Desarrollo Web a Medida', 'Sitios web corporativos, e-commerce y aplicaciones web optimizadas.', 'Desarrollo Web', '🌐', '/images/services/desarrollo-web.jpg', 'https://www.youtube.com/embed/dQw4w9WgXcQ', 'Webs corporativas, landings y e-commerce optimizados para conversión.', 'Arquitectura moderna, rendimiento y SEO. Implementamos soluciones totalmente a medida.', '["Sitios Web Corporativos", "E-commerce", "PWA", "Landing pages de alta conversión"]', 'Cotizar Proyecto Web', 'Hola ROMARQTECH, estoy interesado en un proyecto web. ¿Podemos conversar?'),
('desarrollo-a-medida', 'Software a Medida', 'ERP, CRM y sistemas internos adaptados a tus procesos.', 'Software a Medida', '⚙️', '/images/services/software-a-medida.jpg', '', 'ERP, CRM y plataformas internas para automatizar tu operación.', 'Analizamos procesos, diseñamos e implementamos sistemas robustos y escalables.', '["ERP y CRM a medida", "Plataformas internas", "APIs e integraciones", "Migración y modernización"]', 'Consultar sobre Software', 'Hola ROMARQTECH, quiero información sobre desarrollo a medida.'),
('apps-moviles', 'Apps Móviles', 'Aplicaciones nativas e híbridas con excelente UX y rendimiento.', 'Aplicaciones Móviles', '📱', '/images/services/apps-moviles.jpg', 'https://www.youtube.com/embed/ysz5S6PUM-U', 'iOS/Android nativas o híbridas con enfoque en experiencia de usuario.', 'Desarrollo completo: diseño, pruebas y publicación en tiendas.', '["Apps nativas", "React Native / híbridas", "Integración con backend", "Soporte y mantenimiento"]', 'Cotizar mi App', 'Hola ROMARQTECH, quiero cotizar una app móvil.');

-- Data for products
INSERT INTO products (id, title, price, short_description, ideal_for, included_modules, cta_text, cta_whatsapp_message) VALUES
('erp-pyme-pack', 'ERP Pyme Pack', '$1,200', 'Contabilidad, inventarios y facturación electrónica. Implementación rápida.', 'Pequeñas y medianas empresas que buscan digitalizar su gestión.', '["Facturación Electrónica (SUNAT)", "Control de Inventario", "Cuentas por Cobrar y Pagar", "Reportes Financieros Básicos"]', 'Adquirir ERP Pyme Pack', 'Hola, estoy interesado en el ERP Pyme Pack. ¿Podrían darme más detalles?'),
('ecommerce-pro', 'E-commerce Pro', '$900', 'Tienda online con gestión de catálogo y pasarelas de pago integradas.', 'Negocios que quieren empezar a vender online de forma profesional.', '["Catálogo de Productos", "Carrito de Compras", "Pasarelas de Pago (MercadoPago, Stripe)", "Gestión de Órdenes", "Diseño Personalizable"]', 'Lanzar mi Tienda Online', 'Hola, me interesa el paquete E-commerce Pro para lanzar mi tienda online.');

-- Data for projects
INSERT INTO projects (id, title, client, category, service_id, cover_image, short_description, challenge, solution, outcome, technologies, gallery, cta_text, cta_whatsapp_message) VALUES
('erp-industrial-metalcorp', 'Sistema ERP para MetalCorp', 'MetalCorp S.A.', 'Software a Medida', 'desarrollo-a-medida', '/images/projects/metalcorp-erp-cover.jpg', 'Optimización de inventario, producción y facturación electrónica para una empresa del sector industrial.', 'El cliente gestionaba su inventario y producción con hojas de cálculo, lo que generaba errores, retrasos y falta de visibilidad en tiempo real sobre el stock y los costos.', 'Desarrollamos un sistema ERP web a medida con módulos de inventario, órdenes de producción, compras y facturación electrónica integrada con SUNAT. La interfaz se diseñó para ser intuitiva y fácil de usar por el personal de planta.', 'Reducción del 15% en mermas de inventario, aumento del 25% en la eficiencia de producción y reportes financieros precisos en tiempo real.', '["React", "Node.js", "PostgreSQL", "Docker", "AWS"]', '["/images/projects/metalcorp-erp-1.jpg", "/images/projects/metalcorp-erp-2.jpg", "/images/projects/metalcorp-erp-3.jpg"]', 'Ver Estudio de Caso', 'Hola, vi el proyecto de MetalCorp en su web y me gustaría saber más sobre soluciones ERP.'),
('ecommerce-moda-sostenible-aura', 'E-commerce para Aura Moda', 'Aura Moda Sostenible', 'Desarrollo Web', 'desarrollo-web', '/images/projects/aura-ecommerce-cover.jpg', 'Tienda online con experiencia de compra premium, gestión de catálogo avanzada y pasarelas de pago internacionales.', 'Aura necesitaba una plataforma de e-commerce que reflejara su identidad de marca premium y sostenible, con una experiencia de usuario impecable y una velocidad de carga superior a la de sus competidores.', 'Implementamos una solución \'Headless Commerce\' utilizando Shopify como backend y un frontend a medida con Next.js. Esto nos dio total libertad creativa en el diseño y garantizó un rendimiento excepcional (98/100 en PageSpeed Insights).', 'Aumento del 40% en la tasa de conversión y una reducción del 50% en el tiempo de carga de la página, mejorando el ranking SEO.', '["Next.js", "Shopify API", "GraphQL", "Vercel", "Tailwind CSS"]', '["/images/projects/aura-ecommerce-1.jpg", "/images/projects/aura-ecommerce-2.jpg"]', 'Ver Estudio de Caso', 'Hola, me interesa un proyecto de e-commerce similar al de Aura Moda.'),
('app-logistica-rapienvio', 'App Móvil para RapiEnvío', 'RapiEnvío Logística', 'Aplicaciones Móviles', 'apps-moviles', '/images/projects/rapienvio-app-cover.jpg', 'Aplicación para transportistas con seguimiento GPS en tiempo real, gestión de entregas y comunicación con la central.', 'La coordinación de la flota de reparto era manual y poco eficiente, sin visibilidad en tiempo real de la ubicación de los transportistas ni del estado de las entregas.', 'Desarrollamos una app móvil nativa para Android que permite a los transportistas ver sus rutas asignadas, optimizarlas, escanear paquetes para confirmar entregas y capturar firmas digitales. Una plataforma web para la central permite monitorear toda la operación en tiempo real.', 'Optimización de las rutas de entrega en un 30%, reducción de los tiempos de llamada a la central en un 80% y 99% de precisión en el seguimiento de paquetes.', '["Kotlin (Android)", "Firebase", "Google Maps API", "Node.js", "React"]', '["/images/projects/rapienvio-app-1.jpg", "/images/projects/rapienvio-app-2.jpg"]', 'Ver Estudio de Caso', 'Hola, me gustaría cotizar una app móvil de logística como la de RapiEnvío.');

-- Data for testimonials
INSERT INTO testimonials (name, role, company, avatar, quote, related_project_id) VALUES
('Juan Pérez', 'Gerente de Operaciones', 'MetalCorp S.A.', '/images/testimonials/juan-perez.jpg', 'El sistema ERP que ROMARQTECH desarrolló para nosotros ha sido un cambio radical. Ahora tenemos control total sobre nuestro inventario y producción. Su equipo entendió nuestras necesidades a la perfección.', 'erp-industrial-metalcorp'),
('Lucía Fernández', 'Fundadora', 'Aura Moda Sostenible', '/images/testimonials/lucia-fernandez.jpg', 'Buscábamos más que una tienda online, queríamos una experiencia digital. ROMARQTECH lo logró. La velocidad y el diseño de nuestro nuevo e-commerce han superado todas las expectativas.', 'ecommerce-moda-sostenible-aura');

-- Data for faqs
INSERT INTO faqs (question, answer) VALUES
('¿Cómo se inicia un proyecto con ustedes?', 'El primer paso es una reunión de descubrimiento. Contáctanos por WhatsApp o correo para agendar una llamada sin costo, donde analizaremos tus necesidades y te propondremos una hoja de ruta.'),
('¿Qué tecnologías utilizan para el desarrollo?', 'Nos especializamos en un stack moderno que incluye React, Node.js, Python, y bases de datos como PostgreSQL y MongoDB. Para móviles, trabajamos con React Native y Flutter, adaptándonos siempre a los requerimientos del proyecto.'),
('¿Ofrecen mantenimiento y soporte post-lanzamiento?', 'Sí. Todos nuestros proyectos incluyen un periodo de garantía. Además, ofrecemos planes de soporte y mantenimiento mensual o anual (SLA) para asegurar el rendimiento y la seguridad continua de tu aplicación.');

-- Data for team_members
INSERT INTO team_members (name, role, avatar, bio, social) VALUES
('Ana García', 'CEO & Fundadora', 'https://i.pravatar.cc/150?u=ana-garcia', 'Líder visionaria con más de 10 años de experiencia en la industria tecnológica.', '{"linkedin": "https://linkedin.com/in/ana-garcia", "dribbble": "https://dribbble.com/ana-garcia"}'),
('Carlos Vega', 'Director de Tecnología (CTO)', 'https://i.pravatar.cc/150?u=carlos-vega', 'Arquitecto de software experto en soluciones escalables y seguras en la nube.', '{"linkedin": "https://linkedin.com/in/carlos-vega", "github": "https://github.com/carlos-vega"}'),
('Sofía Reyes', 'Líder de Proyectos (PM)', 'https://i.pravatar.cc/150?u=sofia-reyes', 'Especialista en metodologías ágiles, garantizando entregas a tiempo y en presupuesto.', NULL);

-- Data for tech_stack
INSERT INTO tech_stack (name, logo, type) VALUES
('React', 'react-logo.svg', 'Frontend'),
('Node.js', 'nodejs-logo.svg', 'Backend'),
('Python', 'python-logo.svg', 'Backend'),
('PostgreSQL', 'postgresql-logo.svg', 'Database'),
('AWS', 'aws-logo.svg', 'Infraestructura'),
('Figma', 'figma-logo.svg', 'Diseño UI/UX');

-- Data for clients
INSERT INTO clients (name, logo) VALUES
('MetalCorp S.A.', '/images/clients/metalcorp-logo.png'),
('Aura Moda', '/images/clients/aura-logo.png'),
('RapiEnvío', '/images/clients/rapienvio-logo.png'),
('InnovaEdu', '/images/clients/innovaedu-logo.png'),
('SaludTotal', '/images/clients/saludtotal-logo.png'),
('FintechNow', '/images/clients/fintechnow-logo.png');

-- Data for recognitions
INSERT INTO recognitions (title, issuer, icon) VALUES
('Top B2B Company Peru 2025', 'Clutch.co', 'Trophy'),
('AWS Certified Solutions Architect', 'Amazon Web Services', 'Cloud'),
('Google Cloud Professional', 'Google Cloud', 'CloudCog');

-- Data for industries
INSERT INTO industries (name) VALUES
('Logística y Transporte'),
('Retail y E-commerce'),
('Fintech'),
('Manufactura'),
('Educación'),
('Salud Digital');

-- Data for plans
INSERT INTO plans (id, name, price_monthly, price_annual, features, badge, highlight) VALUES
('plan-growth', 'Growth', 500.00, 5000.00, '["Sitio Web Corporativo", "Optimización SEO On-Page", "Blog administrable", "Soporte técnico (10h/mes)", "Reportes mensuales"]', 'Para empresas en crecimiento', FALSE),
('plan-scale', 'Scale', 1200.00, 12000.00, '["Plataforma E-commerce", "Integración de pasarelas de pago", "Panel de gestión avanzado", "Soporte prioritario (25h/mes)", "Consultoría SEO/CRO"]', 'El más popular', TRUE),
('plan-enterprise', 'Enterprise', NULL, NULL, '["Desarrollo de Software a Medida (ERP/CRM)", "Arquitectura Cloud escalable", "Integraciones vía API", "Acuerdo de Nivel de Servicio (SLA)", "Equipo dedicado"]', 'Soluciones a medida', FALSE);

-- Data for selection_process_steps
INSERT INTO selection_process_steps (title, detail) VALUES
('Envío de CV', 'Recibimos tu CV y lo revisamos en 3-5 días hábiles.'),
('Entrevista Técnica', 'Entrevista con preguntas prácticas y prueba técnica.'),
('Entrevista con RRHH', 'Validación de fit y condiciones.'),
('Oferta', 'En caso de resultado positivo, se emite oferta formal.');

-- Data for careers
INSERT INTO careers (id, title, location, type, posted_at, summary, responsibilities, requirements, benefits, process, apply_cta_text, apply_cta_whatsapp_message) VALUES
('frontend-dev-2025', 'Desarrollador/a Frontend (React)', 'Lima / Remoto', 'Full-time', '2025-08-01', 'Buscamos un/a desarrollador/a frontend con experiencia en React, Next.js y buenas prácticas de accesibilidad y rendimiento.', '["Implementar interfaces responsivas y accesibles", "Colaborar con diseñadores en prototipos y entregables", "Optimizar rendimiento y Core Web Vitals"]', '["3+ años con React", "Experiencia con Next.js y Tailwind", "Buen nivel de inglés técnico"]', '["Trabajo remoto parcial", "Bono anual por desempeño", "Plan de salud"]', '[{"title": "Preselección de CV", "detail": "Revisión en 3-5 días hábiles"}, {"title": "Entrevista técnica", "detail": "Pair programming + preguntas"}, {"title": "Entrevista con Lead", "detail": "Revisión de fit y condiciones"}]', 'Aplicar ahora', 'Hola ROMARQTECH, quiero postular al puesto Desarrollador Frontend.'),
('backend-dev-2025', 'Desarrollador/a Backend (Node.js)', 'Lima / Remoto', 'Full-time', '2025-07-15', 'Desarrollador backend con experiencia en Node.js, diseño de APIs y bases de datos relacionales.', '["Diseñar y mantener APIs REST/GraphQL", "Construir procesos de integración y despliegue", "Garantizar seguridad y observabilidad"]', '["3+ años con Node.js", "Experiencia con PostgreSQL", "Familiaridad con Docker y CI/CD"]', '["Seguro de salud", "Bonos por objetivos", "Oportunidad de crecimiento"]', '[{"title": "Revisión de CV", "detail": "Screening inicial"}, {"title": "Prueba técnica", "detail": "Ejercicio práctico en horas"}, {"title": "Entrevista final", "detail": "Feedback y oferta"}]', 'Enviar CV', 'Hola ROMARQTECH, me interesa la posición Backend Node.js.');

-- Data for contact_availability_defaults
INSERT INTO contact_availability_defaults (time, is_available) VALUES
('09:00', TRUE),
('11:00', TRUE),
('14:00', TRUE),
('16:00', TRUE);

-- Data for contact_availability_by_date
INSERT INTO contact_availability_by_date (date, time, is_available) VALUES
('2025-08-29', '09:00', TRUE),
('2025-08-29', '11:00', FALSE),
('2025-08-29', '14:00', TRUE),
('2025-08-29', '16:00', TRUE),
('2025-08-30', '09:00', FALSE),
('2025-08-30', '11:00', FALSE),
('2025-08-30', '14:00', TRUE),
('2025-08-30', '16:00', TRUE),
('2025-09-02', '09:00', TRUE),
('2025-09-02', '11:00', TRUE),
('2025-09-02', '14:00', FALSE),
('2025-09-02', '16:00', TRUE);

-- Data for contact_availability_by_service
INSERT INTO contact_availability_by_service (service_id, date, time, is_available) VALUES
('desarrollo-web', '2025-08-29', '09:00', TRUE),
('desarrollo-web', '2025-08-29', '11:00', FALSE),
('desarrollo-web', '2025-08-29', '14:00', TRUE),
('desarrollo-web', '2025-08-29', '16:00', FALSE),
('apps-moviles', '2025-08-30', '09:00', TRUE),
('apps-moviles', '2025-08-30', '11:00', TRUE),
('apps-moviles', '2025-08-30', '14:00', FALSE),
('apps-moviles', '2025-08-30', '16:00', FALSE);

-- Default admin user (password: admin123)
INSERT INTO users (username, password, email, role) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@example.com', 'admin');