<style>
    /* Estilos para formularios, consistentes con el resto del panel */
    .form-container { width: 100%; }
    .page-header { margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-section-title { font-size: 18px; color: #343a40; padding-bottom: 10px; border-bottom: 1px solid #dee2e6; margin-top: 30px; margin-bottom: 20px; }
    .form-grid { display: grid; gap: 25px; grid-template-columns: 1fr; }
    @media (min-width: 768px) { .form-grid { grid-template-columns: repeat(2, 1fr); } }
    .form-group { margin-bottom: 20px; }
    .form-grid .form-group { margin-bottom: 0; }
    .form-group label { display: block; font-weight: 600; color: #343a40; margin-bottom: 8px; }
    .form-group input[type="text"], .form-group textarea, .form-group select {
        width: 100%; padding: 12px; border: 1px solid #dee2e6; border-radius: 6px; font-size: 16px; font-family: inherit; box-sizing: border-box; transition: all 0.3s ease;
        background-color: #fff;
    }
    .form-group input:focus, .form-group textarea:focus, .form-group select:focus { 
        outline: none; border-color: #007bff; box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25); 
    }
    .form-group textarea { min-height: 150px; resize: vertical; }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn { text-decoration: none; color: #fff; background-color: #007bff; padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500; font-size: 16px; cursor: pointer; transition: all 0.3s ease; display: inline-block; }
    .btn:hover { background-color: #0056b3; transform: translateY(-2px); }
    .btn-secondary { color: #343a40; background-color: transparent; font-weight: 500; text-decoration: none; padding: 12px 0; }
    .btn-secondary:hover { text-decoration: underline; }
    .message.error { color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7; padding: 15px; margin-bottom: 20px; border-radius: 6px; }

    /* Estilos para el selector de avatar */
    .avatar-preview-label {
        display: block;
        width: 120px;
        height: 120px;
        border: 2px dashed #dee2e6;
        border-radius: 50%;
        margin-bottom: 15px;
        background-color: #f8f9fa;
        background-size: cover;
        background-position: center;
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }
    .avatar-preview-label .placeholder-text {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #6c757d;
        font-size: 14px;
        text-align: center;
        font-weight: normal;
        transition: opacity 0.3s ease;
    }
    .avatar-preview-label:hover { border-color: #007bff; }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Crear Nuevo Testimonio</h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/testimonials/create'); ?>" method="POST" enctype="multipart/form-data">
        
        <h4 class="form-section-title">Información del Autor</h4>
        
        <div class="form-group">
            <label>Avatar</label>
            <label for="avatar_file" class="avatar-preview-label" id="avatar_preview">
                <span class="placeholder-text">Seleccionar Avatar</span>
            </label>
            <input type="file" id="avatar_file" name="avatar" accept="image/png, image/jpeg, image/webp" style="display: none;">
        </div>

        <div class="form-grid">
            <div class="form-group">
                <label for="name">Nombre</label>
                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($testimonialData['name'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="role">Cargo (ej: Gerente General)</label>
                <input type="text" id="role" name="role" value="<?php echo htmlspecialchars($testimonialData['role'] ?? ''); ?>">
            </div>
        </div>
        <div class="form-group">
            <label for="company">Empresa</label>
            <input type="text" id="company" name="company" value="<?php echo htmlspecialchars($testimonialData['company'] ?? ''); ?>">
        </div>

        <h4 class="form-section-title">Contenido del Testimonio</h4>
        <div class="form-group">
            <label for="quote">Cita / Testimonio</label>
            <textarea id="quote" name="quote" required><?php echo htmlspecialchars($testimonialData['quote'] ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label for="related_project_id">Proyecto Relacionado (Opcional)</label>
            <select id="related_project_id" name="related_project_id">
                <option value="">-- Seleccionar Proyecto --</option>
                <?php foreach ($projects as $project): ?>
                    <option value="<?php echo htmlspecialchars($project['id']); ?>"
                        <?php echo (isset($testimonialData['related_project_id']) && $testimonialData['related_project_id'] == $project['id']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($project['title']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn">Crear Testimonio</button>
            <a href="<?php echo url('admin/testimonials'); ?>" class="btn-secondary">Cancelar</a>
        </div>
    </form>
</div>

<script>
    const avatarFileInput = document.getElementById('avatar_file');
    const avatarPreview = document.getElementById('avatar_preview');
    const placeholderText = avatarPreview.querySelector('.placeholder-text');

    avatarFileInput.addEventListener('change', function() {
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                avatarPreview.style.backgroundImage = `url(${e.target.result})`;
                if (placeholderText) {
                    placeholderText.style.opacity = '0';
                }
            }
            reader.readAsDataURL(this.files[0]);
        }
    });
</script>