<style>
    /* Estilos estandarizados del panel */
    .form-container { width: 100%; }
    .page-header { margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-group { margin-bottom: 20px; }
    .form-group label { display: block; font-weight: 600; color: #343a40; margin-bottom: 8px; }
    .form-group input[type="text"], .form-group input[type="file"] {
        width: 100%; padding: 12px; border: 1px solid #dee2e6; border-radius: 6px; font-size: 16px; box-sizing: border-box; transition: all 0.3s ease;
    }
    .form-group input[type="file"] { padding: 9px; }
    .form-group input:focus { outline: none; border-color: #007bff; box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25); }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn { text-decoration: none; padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500; font-size: 16px; cursor: pointer; transition: all 0.3s ease; }
    .btn.btn-primary { color: #fff; background-color: #007bff; }
    .btn.btn-primary:hover { background-color: #0056b3; }
    .btn.btn-secondary { color: #343a40; background-color: transparent; padding-left: 0; padding-right: 0; }
    .btn.btn-secondary:hover { text-decoration: underline; }
    .message.error { color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7; padding: 15px; margin-bottom: 20px; border-radius: 6px; }
    .image-preview { display: flex; align-items: center; gap: 15px; margin-top: 10px; }
    .image-preview img { max-height: 40px; background-color: #f8f9fa; padding: 5px; border-radius: 4px; border: 1px solid #dee2e6; }
    .delete-checkbox { display: flex; align-items: center; gap: 8px; font-size: 14px; margin-top: 10px; }
    .delete-checkbox label { margin-bottom: 0; font-weight: normal; color: #dc3545; }
    .delete-checkbox input { width: auto; }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Editar Tecnología: <?php echo htmlspecialchars($this->tech->name ?? ''); ?></h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/tech_stack/edit?id=' . urlencode($this->tech->id ?? '')); ?>" method="POST" enctype="multipart/form-data">
        
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($this->tech->id ?? ''); ?>">

        <div class="form-group">
            <label for="name">Nombre de la Tecnología</label>
            <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($this->tech->name ?? ''); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="type">Tipo (ej: Frontend, Backend, Database)</label>
            <input type="text" id="type" name="type" value="<?php echo htmlspecialchars($this->tech->type ?? ''); ?>">
        </div>

        <div class="form-group">
            <label for="logo">Logo</label>
            <input type="file" id="logo" name="logo" accept="image/png, image/jpeg, image/webp, image/svg+xml">
            
            <?php if ($this->tech->logo): ?>
                <div class="image-preview">
                    <span>Logo actual:</span>
                    <img src="<?php echo url($this->tech->logo); ?>" alt="Logo actual">
                </div>
                <div class="delete-checkbox">
                    <input type="checkbox" id="delete_logo" name="delete_logo">
                    <label for="delete_logo">Eliminar logo actual</label>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">Actualizar Tecnología</button>
            <a href="<?php echo url('admin/tech_stack'); ?>" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</div>