<style>
    /* Estilos estandarizados del panel */
    .form-container { width: 100%; }
    .page-header { margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-group { margin-bottom: 20px; }
    .form-group label { display: block; font-weight: 600; color: #343a40; margin-bottom: 8px; }
    .form-group input[type="text"], .form-group input[type="file"] {
        width: 100%; padding: 12px; border: 1px solid #dee2e6; border-radius: 6px; font-size: 16px; box-sizing: border-box; transition: all 0.3s ease;
    }
    .form-group input[type="file"] { padding: 9px; }
    .form-group input:focus { outline: none; border-color: #007bff; box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25); }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn { text-decoration: none; padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500; font-size: 16px; cursor: pointer; transition: all 0.3s ease; }
    .btn.btn-primary { color: #fff; background-color: #007bff; }
    .btn.btn-primary:hover { background-color: #0056b3; }
    .btn.btn-secondary { color: #343a40; background-color: transparent; padding-left: 0; padding-right: 0; }
    .btn.btn-secondary:hover { text-decoration: underline; }
    .message.error { color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7; padding: 15px; margin-bottom: 20px; border-radius: 6px; }
    .image-preview { width: 100%; max-width: 150px; height: 60px; border: 2px dashed #dee2e6; border-radius: 8px; display: flex; align-items: center; justify-content: center; font-size: 14px; color: #6c757d; overflow: hidden; padding: 10px; background-color: #f8f9fa; margin-top: 10px; }
    .image-preview img { max-width: 100%; max-height: 100%; object-fit: contain; }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Añadir Nueva Tecnología</h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/tech_stack/create'); ?>" method="POST" enctype="multipart/form-data">
        
        <div class="form-group">
            <label for="name">Nombre de la Tecnología</label>
            <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($techData['name'] ?? ''); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="type">Tipo (ej: Frontend, Backend, Database)</label>
            <input type="text" id="type" name="type" value="<?php echo htmlspecialchars($techData['type'] ?? ''); ?>">
        </div>

        <div class="form-group">
            <label for="logo">Logo (SVG, PNG, JPG)</label>
            <input type="file" id="logo" name="logo" accept="image/png, image/jpeg, image/webp, image/svg+xml">
            <div class="image-preview" id="logo-preview">
                <span>Previsualización</span>
            </div>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">Crear Tecnología</button>
            <a href="<?php echo url('admin/tech_stack'); ?>" class="btn-secondary">Cancelar</a>
        </div>
    </form>
</div>

<script>
    document.getElementById('logo').addEventListener('change', function(event) {
        const preview = document.getElementById('logo-preview');
        const file = event.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.innerHTML = `<img src="${e.target.result}" alt="Nueva previsualización">`;
            }
            reader.readAsDataURL(file);
        } else {
            preview.innerHTML = '<span>Previsualización</span>';
        }
    });
</script>