<style>
    /* Estilos estandarizados del panel */
    .form-container { width: 100%; }
    .page-header { margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-group { margin-bottom: 20px; }
    .form-group label { display: block; font-weight: 600; color: #343a40; margin-bottom: 8px; }
    .form-group input[type="text"], .form-group textarea {
        width: 100%; padding: 12px; border: 1px solid #dee2e6; border-radius: 6px; font-size: 16px; box-sizing: border-box; transition: all 0.3s ease;
    }
    .form-group input:focus, .form-group textarea:focus { outline: none; border-color: #007bff; box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25); }
    .form-group textarea { min-height: 120px; resize: vertical; }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn { text-decoration: none; padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500; font-size: 16px; cursor: pointer; transition: all 0.3s ease; }
    .btn.btn-primary { color: #fff; background-color: #007bff; }
    .btn.btn-primary:hover { background-color: #0056b3; }
    .btn.btn-secondary { color: #343a40; background-color: transparent; padding-left: 0; padding-right: 0; }
    .btn.btn-secondary:hover { text-decoration: underline; }
    .message.error { color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7; padding: 15px; margin-bottom: 20px; border-radius: 6px; }

    /* Estilos para el selector de avatar (igual que en testimonios) */
    .avatar-preview-label { display: block; width: 120px; height: 120px; border: 2px dashed #dee2e6; border-radius: 50%; margin-bottom: 15px; background-color: #f8f9fa; background-size: cover; background-position: center; cursor: pointer; position: relative; overflow: hidden; }
    .avatar-preview-label .placeholder-text { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #6c757d; text-align: center; background: rgba(255,255,255,0.7); padding: 5px; border-radius: 5px; opacity: 0; transition: opacity 0.3s ease; }
    .avatar-preview-label:hover .placeholder-text { opacity: 1; }
    .delete-checkbox { display: flex; align-items: center; gap: 8px; margin-top: -10px; font-size: 14px; }
    .delete-checkbox label { color: #dc3545; font-weight: normal; }
    .delete-checkbox input { width: auto; }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Editar Miembro: <?php echo htmlspecialchars($this->teamMember->name ?? ''); ?></h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/team_members/edit?id=' . urlencode($this->teamMember->id ?? '')); ?>" method="POST" enctype="multipart/form-data">
        
        <div class="form-group">
            <label>Avatar</label>
            <?php $avatarUrl = $this->teamMember->avatar ? url($this->teamMember->avatar) : ''; ?>
            
            <label for="avatar_file" class="avatar-preview-label" id="avatar_preview" style="background-image: url('<?php echo $avatarUrl; ?>');">
                <span class="placeholder-text">Cambiar Avatar</span>
            </label>
            <input type="file" id="avatar_file" name="avatar" accept="image/*" style="display: none;">

            <?php if ($this->teamMember->avatar): ?>
            <div class="delete-checkbox">
                <input type="checkbox" id="delete_avatar" name="delete_avatar">
                <label for="delete_avatar">Eliminar avatar actual</label>
            </div>
            <?php endif; ?>
        </div>

        <div class="form-group">
            <label for="name">Nombre Completo</label>
            <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($this->teamMember->name ?? ''); ?>" required>
        </div>
        <div class="form-group">
            <label for="role">Rol o Cargo</label>
            <input type="text" id="role" name="role" value="<?php echo htmlspecialchars($this->teamMember->role ?? ''); ?>" required>
        </div>
        <div class="form-group">
            <label for="bio">Biografía</label>
            <textarea id="bio" name="bio" rows="4"><?php echo htmlspecialchars($this->teamMember->bio ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label for="social">Redes Sociales (en formato JSON)</label>
            <textarea id="social" name="social" rows="4"><?php echo htmlspecialchars(json_encode($this->teamMember->social ?? [], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); ?></textarea>
            <small>Ejemplo: {"linkedin": "https://...", "github": "https://..."}</small>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">Actualizar Miembro</button>
            <a href="<?php echo url('admin/team_members'); ?>" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</div>

<script>
    // Script para la previsualización del avatar (idéntico a los otros formularios)
    document.getElementById('avatar_file').addEventListener('change', function(event) {
        const preview = document.getElementById('avatar_preview');
        if (event.target.files && event.target.files[0]) {
            const reader = new FileReader();
            reader.onload = e => { 
                preview.style.backgroundImage = `url(${e.target.result})`;
            };
            reader.readAsDataURL(event.target.files[0]);
        }
    });
</script>