<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Ajustes del Sitio - ROMARQTECH Admin</title>
    <style>
        :root {
            --primary-color: #007bff;
            --primary-hover-color: #0056b3;
            --light-bg: #f8f9fa;
            --white-bg: #ffffff;
            --border-color: #dee2e6;
            --text-dark: #343a40;
            --text-light: #6c757d;
            --success-bg: #d4edda;
            --success-text: #155724;
            --error-bg: #f8d7da;
            --error-text: #721c24;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --border-radius: 8px;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            background-color: var(--light-bg);
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        h2 {
            color: var(--text-dark);
            margin-bottom: 20px;
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
        }

        .form-section {
            background-color: var(--white-bg);
            padding: 25px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        
        .form-section h3 {
            margin: 0 0 10px 0;
            color: var(--primary-color);
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 10px;
            font-size: 18px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: var(--text-dark);
            font-weight: 600;
            font-size: 14px;
        }

        .form-group input[type="text"],
        .form-group input[type="email"],
        .form-group textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 16px;
            box-sizing: border-box; /* Importante para el ancho */
        }
        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        /* --- Estilos para la carga de logos --- */
        .logo-uploader-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 15px;
        }
        .logo-uploader {
            border: 2px dashed var(--border-color);
            border-radius: var(--border-radius);
            padding: 15px;
            text-align: center;
            cursor: pointer;
            transition: border-color 0.3s ease, background-color 0.3s ease;
        }
        .logo-uploader:hover {
            border-color: var(--primary-color);
            background-color: #f8f9fa;
        }
        .logo-uploader img {
            max-width: 100%;
            height: 60px;
            object-fit: contain;
            margin-bottom: 10px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        .logo-uploader span {
            font-size: 14px;
            color: var(--text-light);
            font-weight: 500;
        }
        .logo-uploader input[type="file"] {
            display: none;
        }

        .submit-container {
            grid-column: 1 / -1; /* Ocupa todo el ancho del grid */
            text-align: right;
        }
        input[type="submit"] {
            background-color: var(--primary-color);
            color: #fff;
            padding: 12px 25px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            transition: background-color 0.3s ease;
        }
        input[type="submit"]:hover {
            background-color: var(--primary-hover-color);
        }

        .message { padding: 15px; margin-bottom: 20px; border-radius: 4px; border: 1px solid transparent; }
        .message.success { background-color: var(--success-bg); color: var(--success-text); border-color: var(--success-text); }
        .message.error { background-color: var(--error-bg); color: var(--error-text); border-color: var(--error-text); }

    </style>
</head>
<body>
    <div class="container">
        <h2>Editar Ajustes del Sitio</h2>

        <?php if (isset($message)): ?>
            <div class="message success"><?php echo $message; ?></div>
        <?php endif; ?>
        <?php if (isset($error)): ?>
            <div class="message error"><?php echo $error; ?></div>
        <?php endif; ?>

<form action="<?php echo url('admin/settings'); ?>" method="POST" enctype="multipart/form-data">
            <div class="form-grid">

                <div class="form-section">
                    <h3>Información General</h3>
                    <div class="form-group">
                        <label for="company_name">Nombre de la Compañía</label>
                        <input type="text" id="company_name" name="company_name" value="<?php echo htmlspecialchars($setting->company_name ?? ''); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="site_url">URL del Sitio</label>
                        <input type="text" id="site_url" name="site_url" value="<?php echo htmlspecialchars($setting->site_url ?? ''); ?>">
                    </div>
                </div>

              <div class="form-section">
    <h3>Logos del Sitio</h3>
    <div class="logo-uploader-grid">
        <label for="site_logo_file" class="logo-uploader">
            <?php
            // Construye la URL correcta para el logo principal o usa el placeholder
            $logo_src = (!empty($setting->site_logo))
                ? url($setting->site_logo)
                : 'https://via.placeholder.com/150x60?text=Logo';
            ?>
            <img id="site_logo_preview" src="<?php echo htmlspecialchars($logo_src); ?>" alt="Vista previa del logo">
            <span>Logo Principal</span>
            <input type="file" id="site_logo_file" name="site_logo" accept="image/*">
        </label>
        <label for="site_logo_rq_file" class="logo-uploader">
            <?php
            // Construye la URL correcta para el logo RQ o usa el placeholder
            $logo_rq_src = (!empty($setting->site_logo_rq))
                ? url($setting->site_logo_rq)
                : 'https://via.placeholder.com/150x60?text=Logo+RQ';
            ?>
            <img id="site_logo_rq_preview" src="<?php echo htmlspecialchars($logo_rq_src); ?>" alt="Vista previa del logo RQ">
            <span>Logo RQ</span>
            <input type="file" id="site_logo_rq_file" name="site_logo_rq" accept="image/*">
        </label>
        <label for="site_logo_square_file" class="logo-uploader">
            <?php
            // Construye la URL correcta para el logo cuadrado o usa el placeholder
            $logo_square_src = (!empty($setting->site_logo_square))
                ? url($setting->site_logo_square)
                : 'https://via.placeholder.com/100x100?text=Logo+Sq';
            ?>
            <img id="site_logo_square_preview" src="<?php echo htmlspecialchars($logo_square_src); ?>" alt="Vista previa del logo cuadrado">
            <span>Logo Cuadrado</span>
            <input type="file" id="site_logo_square_file" name="site_logo_square" accept="image/*">
        </label>
    </div>
</div>

                <div class="form-section">
                    <h3>Información de Contacto</h3>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($setting->email ?? ''); ?>">
                    </div>
                    <div class="form-group">
                        <label for="phone">Teléfono</label>
                        <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($setting->phone ?? ''); ?>">
                    </div>
                    <div class="form-group">
                        <label for="whatsapp_number">Número de WhatsApp</label>
                        <input type="text" id="whatsapp_number" name="whatsapp_number" value="<?php echo htmlspecialchars($setting->whatsapp_number ?? ''); ?>">
                    </div>
                    <div class="form-group">
                        <label for="address">Dirección</label>
                        <input type="text" id="address" name="address" value="<?php echo htmlspecialchars($setting->address ?? ''); ?>">
                    </div>
                </div>

                <div class="form-section">
                    <h3>SEO y Metadatos</h3>
                    <div class="form-group">
                        <label for="site_title">Título del Sitio</label>
                        <input type="text" id="site_title" name="site_title" value="<?php echo htmlspecialchars($setting->site_title ?? ''); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="site_title_template">Plantilla de Título (ej: %s - Mi Compañía)</label>
                        <input type="text" id="site_title_template" name="site_title_template" value="<?php echo htmlspecialchars($setting->site_title_template ?? ''); ?>">
                    </div>
                    <div class="form-group">
                        <label for="site_description">Descripción del Sitio</label>
                        <textarea id="site_description" name="site_description"><?php echo htmlspecialchars($setting->site_description ?? ''); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="keywords">Palabras Clave (separadas por coma)</label>
                        <textarea id="keywords" name="keywords"><?php echo htmlspecialchars($setting->keywords ?? ''); ?></textarea>
                    </div>
                </div>
                
                <div class="submit-container">
                    <input type="submit" value="Guardar Cambios">
                </div>
            </div>
        </form>
    </div>

    <script>
        function setupImagePreview(inputId, previewId) {
            const input = document.getElementById(inputId);
            const preview = document.getElementById(previewId);

            if (input && preview) {
                input.addEventListener('change', function(event) {
                    const file = event.target.files[0];
                    if (file) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            preview.src = e.target.result;
                        }
                        reader.readAsDataURL(file);
                    }
                });
            }
        }

        // Inicializar la vista previa para cada cargador de logos
        document.addEventListener('DOMContentLoaded', function() {
            setupImagePreview('site_logo_file', 'site_logo_preview');
            setupImagePreview('site_logo_rq_file', 'site_logo_rq_preview');
            setupImagePreview('site_logo_square_file', 'site_logo_square_preview');
        });
    </script>
</body>
</html>