<style>
    /* Estilos estandarizados del panel */
    .form-container { width: 100%; }
    .page-header { margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-group { margin-bottom: 20px; }
    .form-group label { display: block; font-weight: 600; color: #343a40; margin-bottom: 8px; }
    .form-group input[type="text"] {
        width: 100%; padding: 12px; border: 1px solid #dee2e6; border-radius: 6px; font-size: 16px; box-sizing: border-box; transition: all 0.3s ease;
    }
    .form-group input:focus { outline: none; border-color: #007bff; box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25); }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn { text-decoration: none; padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500; font-size: 16px; cursor: pointer; transition: all 0.3s ease; }
    .btn.btn-primary { color: #fff; background-color: #007bff; }
    .btn.btn-primary:hover { background-color: #0056b3; }
    .btn.btn-secondary { color: #343a40; background-color: transparent; padding-left: 0; padding-right: 0; }
    .btn.btn-secondary:hover { text-decoration: underline; }
    .message.error { color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7; padding: 15px; margin-bottom: 20px; border-radius: 6px; }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Editar Reconocimiento</h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/recognitions/edit?id=' . urlencode($this->recognition->id ?? '')); ?>" method="POST">
        
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($this->recognition->id ?? ''); ?>">

        <div class="form-group">
            <label for="title">Título</label>
            <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($this->recognition->title ?? ''); ?>" required>
        </div>
        <div class="form-group">
            <label for="issuer">Emisor (ej: Clutch.co, Google)</label>
            <input type="text" id="issuer" name="issuer" value="<?php echo htmlspecialchars($this->recognition->issuer ?? ''); ?>">
        </div>
        <div class="form-group">
            <label for="icon">Icono</label>
            <input type="text" id="icon" name="icon" value="<?php echo htmlspecialchars($this->recognition->icon ?? ''); ?>">
            <small>Nombre del icono que se usará para mostrarlo (ej: trophy, cloud-check).</small>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">Actualizar Reconocimiento</button>
            <a href="<?php echo url('admin/recognitions'); ?>" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</div>