<style>
    /* Estilos para la página de gestión (idénticos a los anteriores) */
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        flex-wrap: wrap;
        gap: 15px;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: var(--text-dark); }
    .btn {
        text-decoration: none; color: #fff; background-color: var(--primary-color);
        padding: 10px 18px; border-radius: 6px; font-weight: 500;
        transition: background-color 0.3s ease, transform 0.2s ease; display: inline-block;
    }
    .btn:hover { background-color: #0056b3; transform: translateY(-2px); }
    .message {
        padding: 15px; margin-bottom: 20px; border-radius: 6px; border: 1px solid transparent;
    }
    .message.success { color: #0f5132; background-color: #d1e7dd; border-color: #badbcc; }
    .message.error { color: #842029; background-color: #f8d7da; border-color: #f5c2c7; }
    .table-container { overflow-x: auto; }
    .data-table {
        width: 100%; border-collapse: collapse; background-color: #fff;
        box-shadow: var(--shadow); border-radius: 8px; overflow: hidden;
    }
    .data-table th, .data-table td {
        padding: 15px; text-align: left; border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
    }
    .data-table thead th {
        background-color: #f8f9fa; font-weight: 600; color: var(--text-dark);
        text-transform: uppercase; font-size: 12px;
    }
    .data-table tbody tr:hover { background-color: #f1f1f1; }
    .data-table tbody tr:last-child td { border-bottom: none; }
    .data-table .actions a {
        text-decoration: none; padding: 6px 12px; border-radius: 20px; font-size: 13px;
        font-weight: 500; margin-right: 5px; transition: background-color 0.3s ease;
    }
    .data-table .actions .edit-btn { color: #fff; background-color: #17a2b8; }
    .data-table .actions .edit-btn:hover { background-color: #138496; }
    .data-table .actions .delete-btn { color: #fff; background-color: #dc3545; }
    .data-table .actions .delete-btn:hover { background-color: #c82333; }
</style>

<div class="page-header">
    <h3>Gestionar Proyectos</h3>
    <a href="<?php echo url('admin/projects/create'); ?>" class="btn">Añadir Nuevo Proyecto</a>
</div>

<?php if (isset($_SESSION['message'])): ?>
    <div class="message success"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></div>
<?php endif; ?>
<?php if (isset($_SESSION['error'])): ?>
    <div class="message error"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
<?php endif; ?>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Título del Proyecto</th>
                <th>Cliente</th>
                <th>Categoría</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($projects)): ?>
                <tr>
                    <td colspan="5" style="text-align: center; padding: 20px;">No se encontraron proyectos.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($projects as $project): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($project['id']); ?></td>
                        <td><strong><?php echo htmlspecialchars($project['title']); ?></strong></td>
                        <td><?php echo htmlspecialchars($project['client']); ?></td>
                        <td><?php echo htmlspecialchars($project['category']); ?></td>
                        <td class="actions">
                            <a href="<?php echo url('admin/projects/edit?id=' . urlencode($project['id'])); ?>" class="edit-btn">Editar</a>
                            <a href="<?php echo url('admin/projects/delete?id=' . urlencode($project['id'])); ?>" class="delete-btn" onclick="return confirm('¿Estás seguro?');">Eliminar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>