<style>
    /* Estilos para formularios, consistentes con el resto del panel */
    .form-container { width: 100%; }
    .page-header { margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-section-title { font-size: 18px; color: #343a40; padding-bottom: 10px; border-bottom: 1px solid #dee2e6; margin-top: 30px; margin-bottom: 20px; }
    .form-grid { display: grid; gap: 25px; grid-template-columns: 1fr; }
    @media (min-width: 768px) { .form-grid { grid-template-columns: repeat(2, 1fr); } }
    .form-group { margin-bottom: 20px; }
    .form-grid .form-group { margin-bottom: 0; }
    .form-group label { display: block; font-weight: 600; color: #343a40; margin-bottom: 8px; }
    .form-group input[type="text"], .form-group textarea {
        width: 100%; padding: 12px; border: 1px solid #dee2e6; border-radius: 6px; font-size: 16px; font-family: inherit; box-sizing: border-box; transition: all 0.3s ease;
    }
    .form-group input:focus, .form-group textarea:focus { outline: none; border-color: #007bff; box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25); }
    .form-group textarea { min-height: 120px; resize: vertical; }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; font-style: italic; }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn { text-decoration: none; color: #fff; background-color: #007bff; padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500; font-size: 16px; cursor: pointer; transition: all 0.3s ease; display: inline-block; }
    .btn:hover { background-color: #0056b3; transform: translateY(-2px); }
    .btn-secondary { color: #343a40; background-color: transparent; font-weight: 500; text-decoration: none; padding: 12px 0; }
    .btn-secondary:hover { text-decoration: underline; }
    .message.error { color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7; padding: 15px; margin-bottom: 20px; border-radius: 6px; }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Crear Nuevo Producto</h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/products/create'); ?>" method="POST">
        
        <h4 class="form-section-title">Información Principal</h4>
        <div class="form-grid">
            <div class="form-group">
                <label for="id">ID del Producto (único)</label>
                <input type="text" id="id" name="id" value="<?php echo htmlspecialchars($productData['id'] ?? ''); ?>" required>
                <small>Ej: prod-nombre-unico-01. Sin espacios ni caracteres especiales.</small>
            </div>
             <div class="form-group">
                <label for="title">Título del Producto</label>
                <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($productData['title'] ?? ''); ?>" required>
            </div>
        </div>
        <div class="form-group">
            <label for="price">Precio (ej: Desde S/ 1,200.00)</label>
            <input type="text" id="price" name="price" value="<?php echo htmlspecialchars($productData['price'] ?? ''); ?>">
        </div>

        <h4 class="form-section-title">Contenido Descriptivo</h4>
        <div class="form-group">
            <label for="short_description">Descripción Corta</label>
            <textarea id="short_description" name="short_description" rows="3"><?php echo htmlspecialchars($productData['short_description'] ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label for="ideal_for">Ideal Para</label>
            <textarea id="ideal_for" name="ideal_for" rows="3"><?php echo htmlspecialchars($productData['ideal_for'] ?? ''); ?></textarea>
        </div>
        <div class="form-group">
            <label for="included_modules">Módulos Incluidos (uno por línea)</label>
            <textarea id="included_modules" name="included_modules" rows="6"><?php echo htmlspecialchars($productData['included_modules'] ?? ''); ?></textarea>
            <small>Cada línea se convertirá en un punto de la lista.</small>
        </div>

        <h4 class="form-section-title">Llamada a la Acción (CTA)</h4>
        <div class="form-grid">
            <div class="form-group">
                <label for="cta_text">Texto del Botón (ej: Lanzar mi web ahora)</label>
                <input type="text" id="cta_text" name="cta_text" value="<?php echo htmlspecialchars($productData['cta_text'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="cta_whatsapp_message">Mensaje de WhatsApp predefinido</label>
                <textarea id="cta_whatsapp_message" name="cta_whatsapp_message" rows="3"><?php echo htmlspecialchars($productData['cta_whatsapp_message'] ?? ''); ?></textarea>
            </div>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn">Crear Producto</button>
            <a href="<?php echo url('admin/products'); ?>" class="btn-secondary">Cancelar</a>
        </div>
    </form>
</div>