<style>
    /* Usamos los mismos estilos del panel de administración para consistencia */
    .admin-page-container { width: 100%; font-family: inherit; }
    .page-header {
        display: flex; justify-content: space-between; align-items: center;
        margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .btn {
        text-decoration: none; padding: 10px 20px; border: none; border-radius: 6px;
        font-weight: 500; font-size: 15px; cursor: pointer; transition: all 0.3s ease;
        display: inline-block; text-align: center;
    }
    .btn-primary { color: #fff; background-color: #007bff; }
    .btn-primary:hover { background-color: #0056b3; }
    .btn-sm { padding: 6px 12px; font-size: 14px; }
    .btn-secondary { color: #fff; background-color: #6c757d; }
    .btn-secondary:hover { background-color: #5a6268; }
    .btn-danger { color: #fff; background-color: #dc3545; }
    .btn-danger:hover { background-color: #c82333; }
    .table-container {
        overflow-x: auto; background-color: #fff; border: 1px solid #dee2e6;
        border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }
    .styled-table { width: 100%; border-collapse: collapse; }
    .styled-table thead tr { background-color: #f8f9fa; color: #495057; text-align: left; }
    .styled-table th, .styled-table td { padding: 12px 15px; vertical-align: middle; }
    .styled-table tbody tr { border-bottom: 1px solid #dee2e6; }
    .styled-table tbody tr:last-of-type { border-bottom: none; }
    .styled-table tbody tr:hover { background-color: #f1f1f1; }
    .actions-cell { display: flex; gap: 10px; }
    .actions-cell form { margin: 0; }
    .message {
        padding: 15px; margin-bottom: 20px; border-radius: 6px; border: 1px solid transparent;
    }
    .message.success { color: #155724; background-color: #d4edda; border-color: #c3e6cb; }
    .message.error { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; }
    .highlight-dot {
        height: 12px; width: 12px; background-color: #6c757d; /* Gris por defecto */
        border-radius: 50%; display: inline-block;
    }
    .highlight-dot.yes { background-color: #28a745; } /* Verde para 'Sí' */
</style>

<div class="admin-page-container">
    <div class="page-header">
        <h3>Gestionar Planes</h3>
        <a href="<?php echo url('admin/plans/create'); ?>" class="btn btn-primary">Añadir Nuevo Plan</a>
    </div>

    <?php if (isset($_SESSION['message'])): ?>
        <div class="message success"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></div>
    <?php endif; ?>
    <?php if (isset($error)): ?>
        <div class="message error"><?php echo $error; ?></div>
    <?php endif; ?>

    <div class="table-container">
        <table class="styled-table">
            <thead>
                <tr>
                    <th>ID del Plan</th>
                    <th>Nombre</th>
                    <th>Precio Mensual</th>
                    <th>Precio Anual</th>
                    <th>Destacado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($plans)): ?>
                    <tr>
                        <td colspan="6" style="text-align: center; padding: 20px;">No se encontraron planes.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($plans as $plan): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($plan['id']); ?></td>
                            <td>
                                <?php echo htmlspecialchars($plan['name']); ?>
                                <?php if (!empty($plan['badge'])): ?>
                                    <span style="background-color: #e2e3e5; color: #495057; padding: 2px 6px; font-size: 12px; border-radius: 4px; margin-left: 8px;"><?php echo htmlspecialchars($plan['badge']); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php // Formateo de precio a moneda local (Soles) ?>
                                S/ <?php echo number_format($plan['price_monthly'] ?? 0, 2, '.', ','); ?>
                            </td>
                            <td>
                                S/ <?php echo number_format($plan['price_annual'] ?? 0, 2, '.', ','); ?>
                            </td>
                            <td>
                                <?php // Indicador visual para 'highlight' ?>
                                <span class="highlight-dot <?php echo $plan['highlight'] ? 'yes' : ''; ?>" title="<?php echo $plan['highlight'] ? 'Sí' : 'No'; ?>"></span>
                            </td>
                            <td>
                                <div class="actions-cell">
                                    <a href="<?php echo url('admin/plans/edit?id=' . urlencode($plan['id'])); ?>" class="btn btn-sm btn-secondary">Editar</a>
                                    
                                    <form action="<?php echo url('admin/plans/delete'); ?>" method="POST" onsubmit="return confirm('¿Estás seguro de que quieres eliminar este plan?');">
                                        <input type="hidden" name="id" value="<?php echo htmlspecialchars($plan['id']); ?>">
                                        <button type="submit" class="btn btn-sm btn-danger">Eliminar</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>