<style>
    /* Estilos consistentes con el resto del panel de administración */
    .form-container { width: 100%; }
    .page-header {
        margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-grid { 
        display: grid; gap: 25px; grid-template-columns: 1fr; 
    }
    @media (min-width: 768px) {
        .form-grid { grid-template-columns: repeat(2, 1fr); }
    }
    .form-group { margin-bottom: 20px; }
    .form-grid .form-group { margin-bottom: 0; }
    .form-group label { display: block; font-weight: 600; color: #495057; margin-bottom: 8px; }
    
    .form-group input[type="text"],
    .form-group input[disabled],
    .form-group textarea {
        width: 100%; padding: 12px; border: 1px solid #ced4da;
        border-radius: 6px; font-size: 16px; box-sizing: border-box;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }
    .form-group input[disabled] { 
        background-color: #e9ecef; 
        cursor: not-allowed; 
    }
    .form-group input:focus, .form-group textarea:focus {
        outline: none; border-color: #80bdff;
        box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    }
    .form-group textarea { min-height: 150px; resize: vertical; }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; }
    
    .form-group-checkbox {
        display: flex; align-items: center; gap: 10px;
        background-color: #f8f9fa; padding: 12px;
        border-radius: 6px; border: 1px solid #dee2e6;
    }
    .form-group-checkbox input[type="checkbox"] { width: 1.2em; height: 1.2em; cursor: pointer; }
    .form-group-checkbox label { margin-bottom: 0; font-weight: normal; }

    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn {
        text-decoration: none; padding: 12px 25px; border: none; border-radius: 6px;
        font-weight: 500; font-size: 16px; cursor: pointer; transition: background-color 0.3s ease;
    }
    .btn-primary { color: #fff; background-color: #007bff; }
    .btn-primary:hover { background-color: #0056b3; }
    .btn-secondary { color: #212529; background-color: #e9ecef; }
    .btn-secondary:hover { background-color: #dae0e5; }
    
    .message.error {
        color: #721c24; background-color: #f8d7da; border: 1px solid #f5c6cb;
        padding: 15px; margin-bottom: 20px; border-radius: 6px;
    }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Editar Plan: <?php echo htmlspecialchars($this->plan->name ?? ''); ?></h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/plans/edit'); ?>" method="POST">
        
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($this->plan->id ?? ''); ?>">

        <div class="form-grid">
            <div class="form-group">
                <label for="id_display">ID del Plan (No se puede editar)</label>
                <input type="text" id="id_display" value="<?php echo htmlspecialchars($this->plan->id ?? ''); ?>" disabled>
            </div>
            <div class="form-group">
                <label for="name">Nombre del Plan</label>
                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($this->plan->name ?? ''); ?>" required>
            </div>
        </div>

        <div class="form-grid">
            <div class="form-group">
                <label for="price_monthly">Precio Mensual</label>
                <input type="text" id="price_monthly" name="price_monthly" value="<?php echo htmlspecialchars($this->plan->price_monthly ?? ''); ?>" placeholder="ej: 950.00">
            </div>
            <div class="form-group">
                <label for="price_annual">Precio Anual</label>
                <input type="text" id="price_annual" name="price_annual" value="<?php echo htmlspecialchars($this->plan->price_annual ?? ''); ?>" placeholder="ej: 9500.00">
            </div>
        </div>

        <div class="form-group">
            <label for="features">Características (una por línea)</label>
            <textarea id="features" name="features" rows="6"><?php 
                // Si 'features' es un array (viene decodificado del controlador), lo convierte en texto.
                echo htmlspecialchars(is_array($this->plan->features ?? null) ? implode("\n", $this->plan->features) : ''); 
            ?></textarea>
        </div>

        <div class="form-grid">
            <div class="form-group">
                <label for="badge">Etiqueta</label>
                <input type="text" id="badge" name="badge" value="<?php echo htmlspecialchars($this->plan->badge ?? ''); ?>" placeholder="ej: Más Popular">
            </div>
            <div class="form-group">
                <label>Opciones</label>
                <div class="form-group-checkbox">
                    <input type="checkbox" id="highlight" name="highlight" value="1" <?php echo ($this->plan->highlight ?? false) ? 'checked' : ''; ?>>
                    <label for="highlight">Destacar este plan en la página de precios</label>
                </div>
            </div>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">Actualizar Plan</button>
            <a href="<?php echo url('admin/plans'); ?>" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</div>