<style>
    /* Estilos para la página de gestión */
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        flex-wrap: wrap;
        gap: 15px;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .message {
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 6px;
        border: 1px solid transparent;
    }
    .message.success { color: #0f5132; background-color: #d1e7dd; border-color: #badbcc; }
    .message.error { color: #842029; background-color: #f8d7da; border-color: #f5c2c7; }
    .table-container { overflow-x: auto; }
    .data-table {
        width: 100%;
        border-collapse: collapse;
        background-color: #fff;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        border-radius: 8px;
        overflow: hidden;
    }
    .data-table th, .data-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #dee2e6;
    }
    .data-table thead th {
        background-color: #f8f9fa;
        font-weight: 600;
        color: #343a40;
        text-transform: uppercase;
        font-size: 12px;
    }
    .data-table tbody tr:hover { background-color: #f1f1f1; }
    .data-table tbody tr:last-child td { border-bottom: none; }
    .data-table .actions a {
        text-decoration: none;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 500;
        margin-right: 5px;
        transition: all 0.3s ease;
    }
    .data-table .actions .edit-btn { color: #fff; background-color: #17a2b8; }
    .data-table .actions .edit-btn:hover { background-color: #138496; transform: translateY(-1px); }
</style>

<div class="page-header">
    <h3>Gestionar Páginas</h3>
</div>

<?php if (isset($_SESSION['message'])): ?>
    <div class="message success"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></div>
<?php endif; ?>
<?php if (isset($_SESSION['error'])): ?>
    <div class="message error"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
<?php endif; ?>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Clave de Página</th>
                <th>Título SEO</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($pages)): ?>
                <tr>
                    <td colspan="4" style="text-align: center; padding: 20px;">No se encontraron páginas.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($pages as $page): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($page['id']); ?></td>
                        <td><strong><?php echo htmlspecialchars($page['page_key']); ?></strong></td>
                        <td><?php echo htmlspecialchars($page['seo_title']); ?></td>
                        <td class="actions">
                            <a href="<?php echo url('admin/pages/edit?page_key=' . urlencode($page['page_key'])); ?>" class="edit-btn">Editar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>