<style>
    /* Estilos para formularios */
    .form-container { width: 100%; }
    .page-header { margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-section-title { font-size: 18px; color: #343a40; padding-bottom: 10px; border-bottom: 1px solid #dee2e6; margin-top: 30px; margin-bottom: 20px; }
    .form-grid { display: grid; gap: 25px; grid-template-columns: 1fr; }
    @media (min-width: 768px) { .form-grid { grid-template-columns: repeat(2, 1fr); } }
    .form-group { margin-bottom: 20px; }
    .form-grid .form-group { margin-bottom: 0; }
    .form-group label { display: block; font-weight: 600; color: #343a40; margin-bottom: 8px; }
    .form-group input[type="text"], .form-group textarea {
        width: 100%; padding: 12px; border: 1px solid #dee2e6; border-radius: 6px; font-size: 16px; font-family: inherit; box-sizing: border-box; transition: all 0.3s ease;
    }
    .form-group input:focus, .form-group textarea:focus { outline: none; border-color: #007bff; box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25); }
    .form-group textarea { min-height: 120px; resize: vertical; }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; font-style: italic; }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn { text-decoration: none; color: #fff; background-color: #007bff; padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500; font-size: 16px; cursor: pointer; transition: all 0.3s ease; display: inline-block; }
    .btn:hover { background-color: #0056b3; transform: translateY(-2px); }
    .btn-secondary { color: #343a40; background-color: transparent; font-weight: 500; text-decoration: none; }
    .btn-secondary:hover { text-decoration: underline; }
    .message.error { color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7; padding: 15px; margin-bottom: 20px; border-radius: 6px; }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Editar Página: <strong><?php echo htmlspecialchars($this->page->page_key ?? ''); ?></strong></h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/pages/edit?page_key=' . urlencode($this->page->page_key ?? '')); ?>" method="POST">
        
        <h4 class="form-section-title">Información SEO</h4>
        <div class="form-grid">
            <div class="form-group">
                <label for="seo_title">Título SEO</label>
                <input type="text" id="seo_title" name="seo_title" value="<?php echo htmlspecialchars($this->page->seo_title ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="seo_description">Descripción SEO</label>
                <textarea id="seo_description" name="seo_description" rows="3"><?php echo htmlspecialchars($this->page->seo_description ?? ''); ?></textarea>
            </div>
        </div>

        <?php if ($this->page->page_key === 'home'): ?>
            <h4 class="form-section-title">Sección Principal (Hero)</h4>
            <div class="form-group">
                <label for="hero_headline">Encabezado Principal</label>
                <textarea id="hero_headline" name="hero_headline" rows="3"><?php echo htmlspecialchars($this->page->hero_headline ?? ''); ?></textarea>
            </div>
            <div class="form-group">
                <label for="hero_subheadline">Sub-encabezado</label>
                <textarea id="hero_subheadline" name="hero_subheadline" rows="3"><?php echo htmlspecialchars($this->page->hero_subheadline ?? ''); ?></textarea>
            </div>
            <div class="form-grid">
                <div class="form-group">
                    <label for="hero_cta_primary_text">Texto del Botón Principal (CTA)</label>
                    <input type="text" id="hero_cta_primary_text" name="hero_cta_primary_text" value="<?php echo htmlspecialchars($this->page->hero_cta_primary_text ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="hero_cta_primary_href">Enlace del Botón Principal (URL)</label>
                    <input type="text" id="hero_cta_primary_href" name="hero_cta_primary_href" value="<?php echo htmlspecialchars($this->page->hero_cta_primary_href ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="hero_cta_secondary_text">Texto del Botón Secundario (CTA)</label>
                    <input type="text" id="hero_cta_secondary_text" name="hero_cta_secondary_text" value="<?php echo htmlspecialchars($this->page->hero_cta_secondary_text ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="hero_cta_secondary_href">Enlace del Botón Secundario (URL)</label>
                    <input type="text" id="hero_cta_secondary_href" name="hero_cta_secondary_href" value="<?php echo htmlspecialchars($this->page->hero_cta_secondary_href ?? ''); ?>">
                </div>
            </div>
            <div class="form-group">
                <label for="stats">Estadísticas (JSON Array)</label>
                <textarea id="stats" name="stats" rows="5"><?php echo htmlspecialchars(json_encode($this->page->stats ?? [], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); ?></textarea>
                <small>Formato: [{"label":"Proyectos","value":150,"suffix":"+"}]</small>
            </div>
        <?php endif; ?>

        <?php if ($this->page->page_key === 'about'): ?>
             <h4 class="form-section-title">Contenido de la Página "Nosotros"</h4>
             <div class="form-grid">
                 <div class="form-group">
                     <label for="mission">Misión</label>
                     <textarea id="mission" name="mission" rows="4"><?php echo htmlspecialchars($this->page->mission ?? ''); ?></textarea>
                 </div>
                 <div class="form-group">
                     <label for="vision">Visión</label>
                     <textarea id="vision" name="vision" rows="4"><?php echo htmlspecialchars($this->page->vision ?? ''); ?></textarea>
                 </div>
             </div>
             <div class="form-group">
                 <label for="timeline">Línea de Tiempo (JSON Array)</label>
                 <textarea id="timeline" name="timeline" rows="7"><?php echo htmlspecialchars(json_encode($this->page->timeline ?? [], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); ?></textarea>
                 <small>Formato: [{"title":"Fundación","desc":"...","date":"2015"}]</small>
             </div>
        <?php endif; ?>

        <div class="form-actions">
            <button type="submit" class="btn">Actualizar Página</button>
            <a href="<?php echo url('admin/pages'); ?>" class="btn-secondary">Cancelar</a>
        </div>
    </form>
</div>