<style>
    /* Estilos consistentes con el resto del panel de administración */
    .admin-page-container { width: 100%; font-family: inherit; }
    .page-header {
        display: flex; justify-content: space-between; align-items: center;
        margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .btn {
        text-decoration: none; padding: 10px 20px; border: none; border-radius: 6px;
        font-weight: 500; font-size: 15px; cursor: pointer; transition: all 0.3s ease;
        display: inline-block; text-align: center;
    }
    .btn-primary { color: #fff; background-color: #007bff; }
    .btn-primary:hover { background-color: #0056b3; }
    .btn-sm { padding: 6px 12px; font-size: 14px; }
    .btn-secondary { color: #fff; background-color: #6c757d; }
    .btn-secondary:hover { background-color: #5a6268; }
    .btn-danger { color: #fff; background-color: #dc3545; }
    .btn-danger:hover { background-color: #c82333; }
    .table-container {
        overflow-x: auto; background-color: #fff; border: 1px solid #dee2e6;
        border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }
    .styled-table { width: 100%; border-collapse: collapse; }
    .styled-table thead tr { background-color: #f8f9fa; color: #495057; text-align: left; }
    .styled-table th, .styled-table td { padding: 12px 15px; vertical-align: middle; }
    .styled-table tbody tr { border-bottom: 1px solid #dee2e6; }
    .styled-table tbody tr:last-of-type { border-bottom: none; }
    .styled-table tbody tr:hover { background-color: #f1f1f1; }
    .actions-cell { display: flex; gap: 10px; }
    .actions-cell form { margin: 0; }
    .message {
        padding: 15px; margin-bottom: 20px; border-radius: 6px; border: 1px solid transparent;
    }
    .message.success { color: #155724; background-color: #d4edda; border-color: #c3e6cb; }
    .message.error { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; }
    .icon-cell i { font-size: 24px; color: #007bff; }
</style>

<div class="admin-page-container">
    <div class="page-header">
        <h3>Gestionar Pasos de Metodología</h3>
        <a href="<?php echo url('admin/methodology_steps/create'); ?>" class="btn btn-primary">Añadir Nuevo Paso</a>
    </div>

    <?php if (isset($_SESSION['message'])): ?>
        <div class="message success"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></div>
    <?php endif; ?>
    <?php if (isset($_SESSION['error'])): ?>
        <div class="message error"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <div class="table-container">
        <table class="styled-table">
            <thead>
                <tr>
                    <th style="width: 80px; text-align: center;">Orden</th>
                    <th style="width: 80px; text-align: center;">Icono</th>
                    <th>Título</th>
                    <th style="width: 150px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($steps)): ?>
                    <tr>
                        <td colspan="4" style="text-align: center; padding: 20px;">No se encontraron pasos de metodología.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($steps as $step): ?>
                        <tr>
                            <td style="text-align: center; font-weight: bold;"><?php echo htmlspecialchars($step['display_order']); ?></td>
                            <td class="icon-cell" style="text-align: center;">
                                <?php if (!empty($step['icon'])): ?>
                                    <i class="<?php echo htmlspecialchars($step['icon']); ?>" title="<?php echo htmlspecialchars($step['icon']); ?>"></i>
                                <?php endif; ?>
                            </td>
                            <td><?php echo htmlspecialchars($step['title']); ?></td>
                            <td>
                                <div class="actions-cell">
                                    <a href="<?php echo url('admin/methodology_steps/edit?id=' . $step['id']); ?>" class="btn btn-sm btn-secondary">Editar</a>
                                    
                                    <form action="<?php echo url('admin/methodology_steps/delete'); ?>" method="POST" onsubmit="return confirm('¿Estás seguro de que quieres eliminar este paso?');">
                                        <input type="hidden" name="id" value="<?php echo $step['id']; ?>">
                                        <button type="submit" class="btn btn-sm btn-danger">Eliminar</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
