<style>
    /* Estilos consistentes con el resto del panel de administración */
    .form-container { width: 100%; }
    .page-header {
        margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-grid { 
        display: grid; gap: 25px; grid-template-columns: 1fr; 
    }
    .form-group { margin-bottom: 20px; }
    .form-group label { display: block; font-weight: 600; color: #495057; margin-bottom: 8px; }
    
    .form-group input[type="text"],
    .form-group input[type="number"],
    .form-group textarea {
        width: 100%; padding: 12px; border: 1px solid #ced4da;
        border-radius: 6px; font-size: 16px; box-sizing: border-box;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }
    .form-group input:focus, .form-group textarea:focus {
        outline: none; border-color: #80bdff;
        box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    }
    .form-group textarea { min-height: 120px; resize: vertical; }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; }
    
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn {
        text-decoration: none; padding: 12px 25px; border: none; border-radius: 6px;
        font-weight: 500; font-size: 16px; cursor: pointer; transition: background-color 0.3s ease;
    }
    .btn-primary { color: #fff; background-color: #007bff; }
    .btn-primary:hover { background-color: #0056b3; }
    .btn-secondary { color: #212529; background-color: #e9ecef; }
    .btn-secondary:hover { background-color: #dae0e5; }
    
    .message.error {
        color: #721c24; background-color: #f8d7da; border: 1px solid #f5c6cb;
        padding: 15px; margin-bottom: 20px; border-radius: 6px;
    }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Editar Paso: <?php echo htmlspecialchars($this->methodologyStep->title ?? ''); ?></h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/methodology_steps/edit'); ?>" method="POST">
        
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($this->methodologyStep->id ?? ''); ?>">

        <div class="form-group">
            <label for="title">Título</label>
            <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($this->methodologyStep->title ?? ''); ?>" required>
        </div>

        <div class="form-group">
            <label for="description">Descripción</label>
            <textarea id="description" name="description" rows="4"><?php echo htmlspecialchars($this->methodologyStep->description ?? ''); ?></textarea>
        </div>

        <div class="form-grid" style="grid-template-columns: 1fr 1fr;">
            <div class="form-group">
                <label for="icon">Icono</label>
                <input type="text" id="icon" name="icon" value="<?php echo htmlspecialchars($this->methodologyStep->icon ?? ''); ?>">
                <small>Ej: "fas fa-lightbulb". Usa clases de Font Awesome.</small>
            </div>
            <div class="form-group">
                <label for="display_order">Orden de Visualización</label>
                <input type="number" id="display_order" name="display_order" value="<?php echo htmlspecialchars($this->methodologyStep->display_order ?? '0'); ?>" required>
                <small>Determina la posición en la lista.</small>
            </div>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">Actualizar Paso</button>
            <a href="<?php echo url('admin/methodology_steps'); ?>" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</div>
