<?php
// Lógica para determinar la ruta activa y resaltar el enlace del menú
$requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$route = '';
if (BASE_URL && strpos($requestUri, BASE_URL) === 0) {
    $route = substr($requestUri, strlen(BASE_URL));
}
$currentRoute = trim($route, '/');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Admin Dashboard'; ?> - ROMARQTECH Admin</title>
    <style>
        :root {
            --sidebar-width-expanded: 260px;
            --sidebar-width-collapsed: 88px;
            --primary-color: #0d6efd;
            --dark-bg: #1c1c1e;
            --light-bg: #f8f9fa;
            --text-light: #f5f5f7;
            --text-dark: #212529;
            --border-color: #dee2e6;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --transition-speed: 0.25s;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            margin: 0;
            background-color: var(--light-bg);
            color: var(--text-dark);
        }

        /* --- Sidebar Moderno --- */
        .sidebar {
            width: var(--sidebar-width-expanded);
            background-color: var(--dark-bg);
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            display: flex;
            flex-direction: column;
            transition: width var(--transition-speed) ease-in-out;
            z-index: 1000;
        }
        
        .sidebar-header {
            padding: 24px;
            text-align: center;
            flex-shrink: 0;
        }
        
        .sidebar-header h2 {
            margin: 0;
            color: var(--primary-color);
            font-weight: 700;
            font-size: 24px;
            white-space: nowrap;
            overflow: hidden;
            transition: opacity var(--transition-speed) ease;
        }
        
        .sidebar-nav {
            flex-grow: 1;
            padding: 0 16px;
            overflow-y: auto;
        }
        
        /* CLAVE: Estilos para la barra de scroll moderna (solo se verá cuando sea necesario) */
        .sidebar-nav::-webkit-scrollbar { width: 6px; }
        .sidebar-nav::-webkit-scrollbar-track { background: transparent; }
        .sidebar-nav::-webkit-scrollbar-thumb { background: #555; border-radius: 10px; }
        .sidebar-nav::-webkit-scrollbar-thumb:hover { background: #777; }

        .sidebar-nav ul { list-style: none; padding: 0; margin: 0; }
        .sidebar-nav .nav-heading {
            font-size: 11px;
            text-transform: uppercase;
            color: #889;
            padding: 20px 12px 8px;
            font-weight: 600;
            white-space: nowrap;
            overflow: hidden;
        }
        
        .sidebar-nav li a {
            color: #aeb2b7;
            text-decoration: none;
            padding: 12px;
            display: flex;
            align-items: center;
            border-radius: 8px;
            margin-bottom: 4px;
            font-weight: 500;
            transition: background-color 0.2s ease, color 0.2s ease;
            white-space: nowrap;
            overflow: hidden;
        }

        .sidebar-nav li a:hover {
            background-color: #2c2c2e;
            color: var(--text-light);
        }

        /* CLAVE: Estilo para el enlace de la página activa */
        .sidebar-nav li a.active {
            background-color: var(--primary-color);
            color: #fff;
            font-weight: 600;
            box-shadow: 0 4px 8px rgba(13, 110, 253, 0.3);
        }

        .sidebar-nav .icon {
            font-size: 22px;
            margin-right: 20px;
            min-width: 28px;
            text-align: center;
            transition: margin-right var(--transition-speed) ease-in-out;
        }
        
        .sidebar-nav .link-text {
            transition: opacity var(--transition-speed) ease;
        }
        
        .sidebar-footer {
            padding: 16px;
            flex-shrink: 0;
        }

        .desktop-toggle {
            width: 100%;
            padding: 12px 0;
            cursor: pointer;
            color: #aeb2b7;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            background: none;
            border: none;
        }
        .desktop-toggle:hover {
            background-color: #2c2c2e;
            color: #fff;
        }

        /* --- Contenido Principal --- */
        .main-content, .header {
            transition: margin-left var(--transition-speed) ease-in-out;
        }
        .main-content { padding: 24px; }
        .header { background-color: #fff; padding: 16px 24px; border-radius: 12px; box-shadow: var(--shadow); display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; }
        .mobile-toggle { display: none; font-size: 24px; background: none; border: none; cursor: pointer; color: var(--text-dark); }
        .header h1 { margin: 0; color: var(--text-dark); font-size: 24px; font-weight: 600; }
        .header .user-info { font-weight: 500; }
        .header .user-info a { color: var(--primary-color); text-decoration: none; margin-left: 10px; }
        .content { background-color: #fff; padding: 24px; border-radius: 12px; box-shadow: var(--shadow); }

        /* --- Estado Contraído --- */
        body.sidebar-collapsed .sidebar { width: var(--sidebar-width-collapsed); }
        body.sidebar-collapsed .sidebar-header h2,
        body.sidebar-collapsed .sidebar-nav .link-text,
        body.sidebar-collapsed .sidebar-nav .nav-heading {
            opacity: 0;
            pointer-events: none;
        }
        body.sidebar-collapsed .sidebar-nav .icon { margin-right: 0; }
        body.sidebar-collapsed .desktop-toggle svg { transform: rotate(180deg); }

        /* --- Lógica Responsiva (Móvil) --- */
        @media (min-width: 768px) {
            .main-content, .header { margin-left: var(--sidebar-width-expanded); }
            body.sidebar-collapsed .main-content,
            body.sidebar-collapsed .header { margin-left: var(--sidebar-width-collapsed); }
        }
        @media (max-width: 767px) {
            .sidebar { transform: translateX(-100%); width: 280px; }
            .sidebar.is-open { transform: translateX(0); box-shadow: 0 0 40px rgba(0,0,0,0.2); }
            .main-content, .header { margin-left: 0; }
            .mobile-toggle { display: block; }
        }
    </style>
</head>
<body class="sidebar-collapsed">
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h2>ROMARQTECH</h2>
        </div>
        <nav class="sidebar-nav">
            <ul>
                <li><a href="<?php echo url('admin/dashboard'); ?>" class="<?php echo ($currentRoute === 'admin/dashboard') ? 'active' : ''; ?>"><span class="icon">🏠</span><span class="link-text">Dashboard</span></a></li>
                <li><a href="<?php echo url('admin/settings'); ?>" class="<?php echo ($currentRoute === 'admin/settings') ? 'active' : ''; ?>"><span class="icon">⚙️</span><span class="link-text">Ajustes del Sitio</span></a></li>
                
                <li class="nav-heading"><span class="link-text">Contenido</span></li>
                <li><a href="<?php echo url('admin/pages'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/pages') ? 'active' : ''; ?>"><span class="icon">📄</span><span class="link-text">Páginas</span></a></li>
                <li><a href="<?php echo url('admin/services'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/services') ? 'active' : ''; ?>"><span class="icon">🛠️</span><span class="link-text">Servicios</span></a></li>
                <li><a href="<?php echo url('admin/products'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/products') ? 'active' : ''; ?>"><span class="icon">📦</span><span class="link-text">Productos</span></a></li>
                <li><a href="<?php echo url('admin/projects'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/projects') ? 'active' : ''; ?>"><span class="icon">🏗️</span><span class="link-text">Proyectos</span></a></li>

                <li class="nav-heading"><span class="link-text">Relaciones</span></li>
                <li><a href="<?php echo url('admin/clients'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/clients') ? 'active' : ''; ?>"><span class="icon">🤝</span><span class="link-text">Clientes</span></a></li>
                <li><a href="<?php echo url('admin/team_members'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/team_members') ? 'active' : ''; ?>"><span class="icon">👥</span><span class="link-text">Equipo</span></a></li>
                <li><a href="<?php echo url('admin/testimonials'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/testimonials') ? 'active' : ''; ?>"><span class="icon">💬</span><span class="link-text">Testimonios</span></a></li>
                
                <li class="nav-heading"><span class="link-text">Catálogos</span></li>
                <li><a href="<?php echo url('admin/faqs'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/faqs') ? 'active' : ''; ?>"><span class="icon">❓</span><span class="link-text">FAQs</span></a></li>
                <li><a href="<?php echo url('admin/recognitions'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/recognitions') ? 'active' : ''; ?>"><span class="icon">🏆</span><span class="link-text">Reconocimientos</span></a></li>
                <li><a href="<?php echo url('admin/differentiators'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/differentiators') ? 'active' : ''; ?>"><span class="icon">💎</span><span class="link-text">Diferenciadores</span></a></li>
                <li><a href="<?php echo url('admin/industries'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/industries') ? 'active' : ''; ?>"><span class="icon">🏭</span><span class="link-text">Industrias</span></a></li>
                <li><a href="<?php echo url('admin/tech_stack'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/tech_stack') ? 'active' : ''; ?>"><span class="icon">💻</span><span class="link-text">Tech Stack</span></a></li>

                <li class="nav-heading"><span class="link-text">Negocio</span></li>
                <li><a href="<?php echo url('admin/plans'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/plans') ? 'active' : ''; ?>"><span class="icon">📈</span><span class="link-text">Planes</span></a></li>
                <li><a href="<?php echo url('admin/careers'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/careers') ? 'active' : ''; ?>"><span class="icon">💼</span><span class="link-text">Carreras</span></a></li>
           <li><a href="<?php echo url('admin/methodology_steps'); ?>" class="<?php echo str_starts_with($currentRoute, 'admin/methodology_steps') ? 'active' : ''; ?>"><span class="icon">📋</span><span class="link-text">Pasos Metodológicos</span></a></li>
            </ul>
        </nav>
        <div class="sidebar-footer">
            <button class="desktop-toggle" id="desktop-toggle" aria-label="Contraer menú">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>
            </button>
        </div>
    </aside>

    <main class="main-content">
        <header class="header">
            <button class="mobile-toggle" id="mobile-toggle" aria-label="Abrir menú">☰</button>
            <h1><?php echo $pageTitle ?? 'Dashboard'; ?></h1>
            <div class="user-info">
                Bienvenido, <strong><?php echo htmlspecialchars($_SESSION['username'] ?? 'Guest'); ?></strong>
                <a href="<?php echo url('logout'); ?>">(Cerrar Sesión)</a>
            </div>
        </header>
        <section class="content">
            <?php echo $content ?? ''; ?>
        </section>
    </main>

    <script>
        const mobileToggle = document.getElementById('mobile-toggle');
        const desktopToggle = document.getElementById('desktop-toggle');
        const sidebar = document.getElementById('sidebar');
        const body = document.body;

        if (mobileToggle) {
            mobileToggle.addEventListener('click', () => sidebar.classList.toggle('is-open'));
        }
        if (desktopToggle) {
            desktopToggle.addEventListener('click', () => {
                body.classList.toggle('sidebar-collapsed');
                // Guardar preferencia en localStorage
                localStorage.setItem('sidebarCollapsed', body.classList.contains('sidebar-collapsed'));
            });
        }
        // Restaurar preferencia al cargar la página
        if (localStorage.getItem('sidebarCollapsed') === 'true') {
            body.classList.add('sidebar-collapsed');
        } else {
            body.classList.remove('sidebar-collapsed');
        }
    </script>
</body>
</html>