<style>
    /* Estilos consistentes con el resto del panel */
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        flex-wrap: wrap;
        gap: 15px;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .btn {
        text-decoration: none;
        color: #fff;
        background-color: #007bff;
        padding: 10px 20px;
        border-radius: 6px;
        font-weight: 500;
        font-size: 15px;
        transition: all 0.3s ease;
        display: inline-block;
    }
    .btn:hover { background-color: #0056b3; transform: translateY(-2px); box-shadow: 0 4px 10px rgba(0,0,0,0.1); }
    .message {
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 6px;
        border: 1px solid transparent;
    }
    .message.success { color: #0f5132; background-color: #d1e7dd; border-color: #badbcc; }
    .message.error { color: #842029; background-color: #f8d7da; border-color: #f5c2c7; }
    .table-container { overflow-x: auto; }
    .data-table {
        width: 100%;
        border-collapse: collapse;
        background-color: #fff;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        border-radius: 8px;
        overflow: hidden;
    }
    .data-table th, .data-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #dee2e6;
        vertical-align: middle;
    }
    .data-table thead th {
        background-color: #f8f9fa;
        font-weight: 600;
        color: #343a40;
        text-transform: uppercase;
        font-size: 12px;
    }
    .data-table tbody tr:hover { background-color: #f1f1f1; }
    .data-table tbody tr:last-child td { border-bottom: none; }
    .data-table .actions {
        display: flex;
        align-items: center;
        gap: 8px;
    }
    .data-table .actions a, .data-table .actions button {
        text-decoration: none;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 500;
        transition: all 0.3s ease;
        cursor: pointer;
    }
    .data-table .actions .edit-btn { color: #fff; background-color: #17a2b8; }
    .data-table .actions .edit-btn:hover { background-color: #138496; }
    .data-table .actions .delete-btn {
        color: #fff;
        background-color: #dc3545;
        border: none;
        font-family: inherit;
    }
    .data-table .actions .delete-btn:hover { background-color: #c82333; }
    .client-logo {
        max-width: 120px;
        max-height: 50px;
        object-fit: contain;
    }
</style>

<div class="page-header">
    <h3>Gestionar Clientes</h3>
    <a href="<?php echo url('admin/clients/create'); ?>" class="btn">Añadir Nuevo Cliente</a>
</div>

<?php if (isset($_SESSION['message'])): ?>
    <div class="message success"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></div>
<?php endif; ?>
<?php if (isset($_SESSION['error'])): ?>
    <div class="message error"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
<?php endif; ?>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Logo</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($clients)): ?>
                <tr>
                    <td colspan="4" style="text-align: center; padding: 20px;">No se encontraron clientes.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($clients as $client): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($client['id']); ?></td>
                        <td><strong><?php echo htmlspecialchars($client['name']); ?></strong></td>
                        <td>
                            <?php if (!empty($client['logo'])): ?>
                                <img src="<?php echo url($client['logo']); ?>"
                                     alt="Logo de <?php echo htmlspecialchars($client['name']); ?>"
                                     class="client-logo">
                            <?php else: ?>
                                <span>Sin logo</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="actions">
                                <a href="<?php echo url('admin/clients/edit?id=' . urlencode($client['id'])); ?>" class="edit-btn">Editar</a>
                                <form action="<?php echo url('admin/clients/delete'); ?>" method="POST" onsubmit="return confirm('¿Estás seguro de que quieres eliminar este cliente?');">
                                    <input type="hidden" name="id" value="<?php echo htmlspecialchars($client['id']); ?>">
                                    <button type="submit" class="delete-btn">Eliminar</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>