<style>
    /* Estilos consistentes con el resto del panel de administración */
    .form-container { width: 100%; }
    .page-header {
        margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6;
    }
    .page-header h3 { margin: 0; font-size: 22px; color: #343a40; }
    .form-grid { 
        display: grid; gap: 25px; grid-template-columns: 1fr; 
    }
    @media (min-width: 768px) {
        .form-grid { grid-template-columns: repeat(2, 1fr); }
    }
    .form-group { margin-bottom: 20px; }
    .form-group label { display: block; font-weight: 600; color: #495057; margin-bottom: 8px; }
    
    .form-group input[type="text"],
    .form-group input[type="file"] {
        width: 100%; padding: 12px; border: 1px solid #ced4da;
        border-radius: 6px; font-size: 16px; box-sizing: border-box;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }
    .form-group input[type="file"] { padding: 9px; }
    .form-group input:focus {
        outline: none; border-color: #80bdff;
        box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; }
    
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn {
        text-decoration: none; padding: 12px 25px; border: none; border-radius: 6px;
        font-weight: 500; font-size: 16px; cursor: pointer; transition: background-color 0.3s ease;
    }
    .btn-primary { color: #fff; background-color: #007bff; }
    .btn-primary:hover { background-color: #0056b3; }
    .btn-secondary { color: #212529; background-color: #e9ecef; }
    .btn-secondary:hover { background-color: #dae0e5; }
    
    .message.error {
        color: #721c24; background-color: #f8d7da; border: 1px solid #f5c6cb;
        padding: 15px; margin-bottom: 20px; border-radius: 6px;
    }
    .image-preview-container { margin-top: 15px; }
    .image-preview {
        width: 100%;
        max-width: 250px; /* Ancho máximo para el logo */
        height: 100px;
        border: 2px dashed #ced4da;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        color: #6c757d;
        overflow: hidden;
        padding: 10px;
        background-color: #f8f9fa;
    }
    .image-preview img {
        max-width: 100%;
        max-height: 100%;
        object-fit: contain; /* 'contain' es mejor para logos que 'cover' */
    }
</style>

<div class="form-container">
    <div class="page-header">
        <h3>Añadir Nuevo Cliente</h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo url('admin/clients/create'); ?>" method="POST" enctype="multipart/form-data">
        <div class="form-grid">
            <div class="form-group">
                <label for="id">ID del Cliente (Único)</label>
                <input type="text" id="id" name="id" value="<?php echo htmlspecialchars($this->client->id ?? ''); ?>" required>
                <small>Ejemplo: nombre-empresa</small>
            </div>
            <div class="form-group">
                <label for="name">Nombre del Cliente</label>
                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($this->client->name ?? ''); ?>" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="logo">Logo del Cliente</label>
            <input type="file" id="logo" name="logo" accept="image/png, image/jpeg, image/svg+xml, image/webp">
            <div class="image-preview-container">
                <div class="image-preview" id="logo-preview">
                    <span>Previsualización del logo</span>
                </div>
            </div>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">Añadir Cliente</button>
            <a href="<?php echo url('admin/clients'); ?>" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const logoInput = document.getElementById('logo');
    const logoPreview = document.getElementById('logo-preview');

    logoInput.addEventListener('change', function(event) {
        const file = event.target.files[0];
        if (file) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                logoPreview.innerHTML = '';
                const img = document.createElement('img');
                img.src = e.target.result;
                logoPreview.appendChild(img);
            }
            
            reader.readAsDataURL(file);
        } else {
            logoPreview.innerHTML = '<span>Previsualización del logo</span>';
        }
    });
});
</script>