<style>
    /* Estilos para la página de gestión */
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        flex-wrap: wrap; /* Para responsividad */
        gap: 15px;
    }

    .page-header h3 {
        margin: 0;
        font-size: 22px;
        color: var(--text-dark);
    }

    /* Botón principal (Añadir nuevo) */
    .btn {
        text-decoration: none;
        color: #fff;
        background-color: var(--primary-color);
        padding: 10px 18px;
        border-radius: 6px;
        font-weight: 500;
        transition: background-color 0.3s ease, transform 0.2s ease;
        display: inline-block;
    }
    .btn:hover {
        background-color: #0056b3;
        transform: translateY(-2px);
    }

    /* Mensajes de notificación (éxito y error) */
    .message {
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 6px;
        border: 1px solid transparent;
    }
    .message.success {
        color: #0f5132;
        background-color: #d1e7dd;
        border-color: #badbcc;
    }
    .message.error {
        color: #842029;
        background-color: #f8d7da;
        border-color: #f5c2c7;
    }

    /* Contenedor de la tabla para hacerla responsive */
    .table-container {
        overflow-x: auto; /* Permite scroll horizontal en móviles */
    }

    /* Tabla de datos moderna */
    .data-table {
        width: 100%;
        border-collapse: collapse; /* Une los bordes de las celdas */
        background-color: #fff;
        box-shadow: var(--shadow);
        border-radius: 8px;
        overflow: hidden; /* Para que el border-radius se aplique a la tabla */
    }

    .data-table th, .data-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid var(--border-color);
    }

    .data-table thead th {
        background-color: #f8f9fa;
        font-weight: 600;
        color: var(--text-dark);
        text-transform: uppercase;
        font-size: 12px;
    }

    .data-table tbody tr:hover {
        background-color: #f1f1f1;
    }
    
    .data-table tbody tr:last-child td {
        border-bottom: none;
    }

    .data-table .actions a {
        text-decoration: none;
        padding: 6px 12px;
        border-radius: 20px; /* Estilo "píldora" */
        font-size: 13px;
        font-weight: 500;
        margin-right: 5px;
        transition: background-color 0.3s ease;
    }

    .data-table .actions .edit-btn {
        color: #fff;
        background-color: #17a2b8; /* Cyan */
    }
    .data-table .actions .edit-btn:hover {
        background-color: #138496;
    }

    .data-table .actions .delete-btn {
        color: #fff;
        background-color: #dc3545; /* Rojo */
    }
    .data-table .actions .delete-btn:hover {
        background-color: #c82333;
    }
</style>

<div class="page-header">
    <h3>Manage Careers</h3>
    <a href="<?php echo url('admin/careers/create'); ?>" class="btn">Add New Career</a>
</div>

<?php if (isset($_SESSION['message'])): ?>
    <div class="message success"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></div>
<?php endif; ?>
<?php if (isset($error)): ?>
    <div class="message error"><?php echo $error; ?></div>
<?php endif; ?>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Title</th>
                <th>Location</th>
                <th>Type</th>
                <th>Posted At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($careers)): ?>
                <tr>
                    <td colspan="6" style="text-align: center; padding: 20px;">No careers found.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($careers as $career): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($career['id']); ?></td>
                        <td><?php echo htmlspecialchars($career['title']); ?></td>
                        <td><?php echo htmlspecialchars($career['location']); ?></td>
                        <td><?php echo htmlspecialchars($career['type']); ?></td>
                        <td><?php echo htmlspecialchars($career['posted_at']); ?></td>
                        <td class="actions">
                            <a href="<?php echo url('admin/careers/edit?id=' . urlencode($career['id'])); ?>" class="edit-btn">Edit</a>
                            <a href="<?php echo url('admin/careers/delete?id=' . urlencode($career['id'])); ?>" class="delete-btn" onclick="return confirm('Are you sure?');">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>