<style>
    /* Estilos para formularios (sin cambios) */
    .form-container {
        width: 100%;
    }
    .page-header {
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 1px solid var(--border-color);
    }
    .page-header h3 { margin: 0; font-size: 22px; color: var(--text-dark); }
    .form-grid { display: grid; gap: 25px; grid-template-columns: 1fr; }
    @media (min-width: 768px) {
        .form-grid { grid-template-columns: repeat(2, 1fr); }
    }
    .form-group { margin-bottom: 20px; }
    .form-grid .form-group { margin-bottom: 0; }
    .form-group label { display: block; font-weight: 600; color: var(--text-dark); margin-bottom: 8px; }
    .form-group input[type="text"],
    .form-group input[type="date"],
    .form-group textarea {
        width: 100%; padding: 12px; border: 1px solid var(--border-color);
        border-radius: 6px; font-size: 16px; font-family: inherit; box-sizing: border-box;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }
    .form-group input:focus,
    .form-group textarea:focus {
        outline: none; border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    }
    .form-group textarea { min-height: 120px; resize: vertical; }
    .form-group small { display: block; margin-top: 5px; color: #6c757d; font-size: 13px; }
    .form-actions { display: flex; gap: 15px; align-items: center; margin-top: 30px; }
    .btn {
        text-decoration: none; color: #fff; background-color: var(--primary-color);
        padding: 12px 25px; border: none; border-radius: 6px; font-weight: 500;
        font-size: 16px; cursor: pointer; transition: background-color 0.3s ease, transform 0.2s ease;
        display: inline-block;
    }
    .btn:hover { background-color: #0056b3; transform: translateY(-2px); }
    .btn-secondary { color: var(--text-dark); background-color: transparent; font-weight: 500; text-decoration: none; }
    .btn-secondary:hover { text-decoration: underline; }
    .message.error {
        color: #842029; background-color: #f8d7da; border: 1px solid #f5c2c7;
        padding: 15px; margin-bottom: 20px; border-radius: 6px;
    }
</style>

<div class="form-container">
    <div class="page-header">
        <h3><?php echo isset($this->career->id) && !empty($this->career->id) ? 'Editar Vacante' : 'Crear Nueva Vacante'; ?></h3>
    </div>

    <?php if (isset($error)): ?>
        <div class="message error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form action="<?php echo isset($this->career->id) && !empty($this->career->id) ? url('admin/careers/edit?id=' . $this->career->id) : url('admin/careers/create'); ?>" method="POST">
        
        <div class="form-grid">
            <div class="form-group">
                <label for="id">ID de la Vacante (Slug único)</label>
                <input type="text" id="id" name="id" value="<?php echo htmlspecialchars($this->career->id ?? ''); ?>" required>
            </div>
            
            <div class="form-group">
                <label for="title">Título del Puesto</label>
                <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($this->career->title ?? ''); ?>" required>
            </div>

            <div class="form-group">
                <label for="location">Ubicación</label>
                <input type="text" id="location" name="location" value="<?php echo htmlspecialchars($this->career->location ?? ''); ?>">
            </div>
            
            <div class="form-group">
                <label for="type">Tipo de Contrato (ej: Tiempo Completo)</label>
                <input type="text" id="type" name="type" value="<?php echo htmlspecialchars($this->career->type ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="posted_at">Fecha de Publicación</label>
                <input type="date" id="posted_at" name="posted_at" value="<?php echo htmlspecialchars($this->career->posted_at ?? date('Y-m-d')); ?>">
            </div>
            
             <div class="form-group">
                <label for="apply_cta_text">Texto del Botón para Aplicar</label>
                <input type="text" id="apply_cta_text" name="apply_cta_text" value="<?php echo htmlspecialchars($this->career->apply_cta_text ?? ''); ?>">
            </div>
        </div>

        <div class="form-group">
            <label for="summary">Resumen del Puesto</label>
            <textarea id="summary" name="summary"><?php echo htmlspecialchars($this->career->summary ?? ''); ?></textarea>
        </div>

        <div class="form-group">
            <label for="responsibilities">Responsabilidades</label>
            <textarea id="responsibilities" name="responsibilities" rows="5"><?php echo htmlspecialchars(is_array($this->career->responsibilities) ? implode("\n", $this->career->responsibilities) : ''); ?></textarea>
            <small>Escribe una responsabilidad por línea.</small>
        </div>

        <div class="form-group">
            <label for="requirements">Requisitos</label>
            <textarea id="requirements" name="requirements" rows="5"><?php echo htmlspecialchars(is_array($this->career->requirements) ? implode("\n", $this->career->requirements) : ''); ?></textarea>
            <small>Escribe un requisito por línea.</small>
        </div>

        <div class="form-group">
            <label for="benefits">Beneficios</label>
            <textarea id="benefits" name="benefits" rows="5"><?php echo htmlspecialchars(is_array($this->career->benefits) ? implode("\n", $this->career->benefits) : ''); ?></textarea>
            <small>Escribe un beneficio por línea.</small>
        </div>
        
        <div class="form-group">
            <label for="process">Proceso de Aplicación</label>
            <textarea id="process" name="process" rows="5"><?php 
                if (isset($this->career->process) && is_array($this->career->process)) {
                    $processLines = array_map(function($p){ return ($p['title'] ?? '') . ':' . ($p['detail'] ?? ''); }, $this->career->process);
                    echo htmlspecialchars(implode("\n", $processLines));
                }
            ?></textarea>
            <small>Escribe un paso por línea, con el formato: <strong>Título:Detalle</strong></small>
        </div>

        <div class="form-group">
            <label for="apply_cta_whatsapp_message">Mensaje de WhatsApp para Aplicar</label>
            <textarea id="apply_cta_whatsapp_message" name="apply_cta_whatsapp_message" rows="3"><?php echo htmlspecialchars($this->career->apply_cta_whatsapp_message ?? ''); ?></textarea>
            <small>Este es el mensaje pre-escrito que se enviará por WhatsApp.</small>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn">
                <?php echo isset($this->career->id) && !empty($this->career->id) ? 'Actualizar Vacante' : 'Crear Vacante'; ?>
            </button>
            <a href="<?php echo url('admin/careers'); ?>" class="btn-secondary">Cancelar</a>
        </div>
    </form>
</div>