<?php

class Testimonial
{
    private $conn;
    private $table_name = "testimonials";

    public $id;
    public $name;
    public $role;
    public $company;
    public $avatar;
    public $quote;
    public $related_project_id;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function readAll()
    {
        $query = "SELECT t.*, p.title as project_title FROM " . $this->table_name . " t LEFT JOIN projects p ON t.related_project_id = p.id ORDER BY t.name ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne()
    {
        $query = "SELECT t.*, p.title as project_title FROM " . $this->table_name . " t LEFT JOIN projects p ON t.related_project_id = p.id WHERE t.id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->name = $row['name'];
            $this->role = $row['role'];
            $this->company = $row['company'];
            $this->avatar = $row['avatar'];
            $this->quote = $row['quote'];
            $this->related_project_id = $row['related_project_id'];
            return true;
        }
        return false;
    }

    public function create()
    {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    name = :name,
                    role = :role,
                    company = :company,
                    avatar = :avatar,
                    quote = :quote,
                    related_project_id = :related_project_id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->role = htmlspecialchars(strip_tags($this->role));
        $this->company = htmlspecialchars(strip_tags($this->company));
        $this->avatar = htmlspecialchars(strip_tags($this->avatar));
        $this->quote = htmlspecialchars(strip_tags($this->quote));
        $this->related_project_id = htmlspecialchars(strip_tags($this->related_project_id));

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':role', $this->role);
        $stmt->bindParam(':company', $this->company);
        $stmt->bindParam(':avatar', $this->avatar);
        $stmt->bindParam(':quote', $this->quote);
        $stmt->bindParam(':related_project_id', $this->related_project_id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    name = :name,
                    role = :role,
                    company = :company,
                    avatar = :avatar,
                    quote = :quote,
                    related_project_id = :related_project_id
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->role = htmlspecialchars(strip_tags($this->role));
        $this->company = htmlspecialchars(strip_tags($this->company));
        $this->avatar = htmlspecialchars(strip_tags($this->avatar));
        $this->quote = htmlspecialchars(strip_tags($this->quote));
        $this->related_project_id = htmlspecialchars(strip_tags($this->related_project_id));

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':role', $this->role);
        $stmt->bindParam(':company', $this->company);
        $stmt->bindParam(':avatar', $this->avatar);
        $stmt->bindParam(':quote', $this->quote);
        $stmt->bindParam(':related_project_id', $this->related_project_id);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function delete()
    {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}

?>