<?php

class TeamMember
{
    private $conn;
    private $table_name = "team_members";

    public $id;
    public $name;
    public $role;
    public $avatar;
    public $bio;
    public $social;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function readAll()
    {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY name ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne()
    {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->name = $row['name'];
            $this->role = $row['role'];
            $this->avatar = $row['avatar'];
            $this->bio = $row['bio'];
            $this->social = json_decode($row['social'], true);
            return true;
        }
        return false;
    }

    public function create()
    {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    name = :name,
                    role = :role,
                    avatar = :avatar,
                    bio = :bio,
                    social = :social";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->role = htmlspecialchars(strip_tags($this->role));
        $this->avatar = htmlspecialchars(strip_tags($this->avatar));
        $this->bio = htmlspecialchars(strip_tags($this->bio));
        $this->social = json_encode($this->social); // Encode JSON

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':role', $this->role);
        $stmt->bindParam(':avatar', $this->avatar);
        $stmt->bindParam(':bio', $this->bio);
        $stmt->bindParam(':social', $this->social);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    name = :name,
                    role = :role,
                    avatar = :avatar,
                    bio = :bio,
                    social = :social
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->role = htmlspecialchars(strip_tags($this->role));
        $this->avatar = htmlspecialchars(strip_tags($this->avatar));
        $this->bio = htmlspecialchars(strip_tags($this->bio));
        $this->social = json_encode($this->social); // Encode JSON

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':role', $this->role);
        $stmt->bindParam(':avatar', $this->avatar);
        $stmt->bindParam(':bio', $this->bio);
        $stmt->bindParam(':social', $this->social);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function delete()
    {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}

?>