<?php

class Setting
{
    private $conn;
    private $table_name = "site_metadata";

    public $id = 1; // Assuming only one row for site_metadata
    public $company_name;
    public $site_title;
    public $site_title_template;
    public $site_description;
    public $site_url;
    public $site_logo;
    public $site_logo_rq;
    public $site_logo_square;
    public $email;
    public $phone;
    public $whatsapp_number;
    public $address;
    public $social;
    public $location;
    public $keywords;
    public $hiring_contact_name;
    public $hiring_contact_email;
    public $hiring_contact_whatsapp_message;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function read()
    {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->company_name = $row['company_name'];
            $this->site_title = $row['site_title'];
            $this->site_title_template = $row['site_title_template'];
            $this->site_description = $row['site_description'];
            $this->site_url = $row['site_url'];
            $this->site_logo = $row['site_logo'];
            $this->site_logo_rq = $row['site_logo_rq'];
            $this->site_logo_square = $row['site_logo_square'];
            $this->email = $row['email'];
            $this->phone = $row['phone'];
            $this->whatsapp_number = $row['whatsapp_number'];
            $this->address = $row['address'];
            $this->social = json_decode($row['social'], true); // Decode JSON
            $this->location = json_decode($row['location'], true); // Decode JSON
            $this->keywords = $row['keywords'];
            $this->hiring_contact_name = $row['hiring_contact_name'];
            $this->hiring_contact_email = $row['hiring_contact_email'];
            $this->hiring_contact_whatsapp_message = $row['hiring_contact_whatsapp_message'];
            return true;
        }
        return false;
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    company_name = :company_name,
                    site_title = :site_title,
                    site_title_template = :site_title_template,
                    site_description = :site_description,
                    site_url = :site_url,
                    site_logo = :site_logo,
                    site_logo_rq = :site_logo_rq,
                    site_logo_square = :site_logo_square,
                    email = :email,
                    phone = :phone,
                    whatsapp_number = :whatsapp_number,
                    address = :address,
                    social = :social,
                    location = :location,
                    keywords = :keywords,
                    hiring_contact_name = :hiring_contact_name,
                    hiring_contact_email = :hiring_contact_email,
                    hiring_contact_whatsapp_message = :hiring_contact_whatsapp_message
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->company_name = htmlspecialchars(strip_tags($this->company_name));
        $this->site_title = htmlspecialchars(strip_tags($this->site_title));
        $this->site_title_template = htmlspecialchars(strip_tags($this->site_title_template));
        $this->site_description = htmlspecialchars(strip_tags($this->site_description));
        $this->site_url = htmlspecialchars(strip_tags($this->site_url));
        $this->site_logo = htmlspecialchars(strip_tags($this->site_logo));
        $this->site_logo_rq = htmlspecialchars(strip_tags($this->site_logo_rq));
        $this->site_logo_square = htmlspecialchars(strip_tags($this->site_logo_square));
        $this->email = htmlspecialchars(strip_tags($this->email));
        $this->phone = htmlspecialchars(strip_tags($this->phone));
        $this->whatsapp_number = htmlspecialchars(strip_tags($this->whatsapp_number));
        $this->address = htmlspecialchars(strip_tags($this->address));
        $this->keywords = htmlspecialchars(strip_tags($this->keywords));
        $this->hiring_contact_name = htmlspecialchars(strip_tags($this->hiring_contact_name));
        $this->hiring_contact_email = htmlspecialchars(strip_tags($this->hiring_contact_email));
        $this->hiring_contact_whatsapp_message = htmlspecialchars(strip_tags($this->hiring_contact_whatsapp_message));

        $stmt->bindParam(':company_name', $this->company_name);
        $stmt->bindParam(':site_title', $this->site_title);
        $stmt->bindParam(':site_title_template', $this->site_title_template);
        $stmt->bindParam(':site_description', $this->site_description);
        $stmt->bindParam(':site_url', $this->site_url);
        $stmt->bindParam(':site_logo', $this->site_logo);
        $stmt->bindParam(':site_logo_rq', $this->site_logo_rq);
        $stmt->bindParam(':site_logo_square', $this->site_logo_square);
        $stmt->bindParam(':email', $this->email);
        $stmt->bindParam(':phone', $this->phone);
        $stmt->bindParam(':whatsapp_number', $this->whatsapp_number);
        $stmt->bindParam(':address', $this->address);
        $stmt->bindParam(':social', json_encode($this->social)); // Encode JSON
        $stmt->bindParam(':location', json_encode($this->location)); // Encode JSON
        $stmt->bindParam(':keywords', $this->keywords);
        $stmt->bindParam(':hiring_contact_name', $this->hiring_contact_name);
        $stmt->bindParam(':hiring_contact_email', $this->hiring_contact_email);
        $stmt->bindParam(':hiring_contact_whatsapp_message', $this->hiring_contact_whatsapp_message);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}

?>