<?php

class Service
{
    private $conn;
    private $table_name = "services";

    public $id;
    public $seo_title;
    public $seo_description;
    public $title;
    public $icon;
    public $image;
    public $video;
    public $short_description;
    public $detailed_description;
    public $key_offerings;
    public $cta_text;
    public $cta_whatsapp_message;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function readAll()
    {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY title ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne()
    {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->seo_title = $row['seo_title'];
            $this->seo_description = $row['seo_description'];
            $this->title = $row['title'];
            $this->icon = $row['icon'];
            $this->image = $row['image'];
            $this->video = $row['video'];
            $this->short_description = $row['short_description'];
            $this->detailed_description = $row['detailed_description'];
            $this->key_offerings = json_decode($row['key_offerings'], true);
            $this->cta_text = $row['cta_text'];
            $this->cta_whatsapp_message = $row['cta_whatsapp_message'];
            return true;
        }
        return false;
    }

    public function create()
    {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    id = :id,
                    seo_title = :seo_title,
                    seo_description = :seo_description,
                    title = :title,
                    icon = :icon,
                    image = :image,
                    video = :video,
                    short_description = :short_description,
                    detailed_description = :detailed_description,
                    key_offerings = :key_offerings,
                    cta_text = :cta_text,
                    cta_whatsapp_message = :cta_whatsapp_message";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->id = htmlspecialchars(strip_tags($this->id));
        $this->seo_title = htmlspecialchars(strip_tags($this->seo_title));
        $this->seo_description = htmlspecialchars(strip_tags($this->seo_description));
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->icon = htmlspecialchars(strip_tags($this->icon));
        $this->image = htmlspecialchars(strip_tags($this->image));
        $this->video = htmlspecialchars(strip_tags($this->video));
        $this->short_description = htmlspecialchars(strip_tags($this->short_description));
        $this->detailed_description = htmlspecialchars(strip_tags($this->detailed_description));
        $this->key_offerings = json_encode($this->key_offerings); // Encode JSON
        $this->cta_text = htmlspecialchars(strip_tags($this->cta_text));
        $this->cta_whatsapp_message = htmlspecialchars(strip_tags($this->cta_whatsapp_message));

        $stmt->bindParam(':id', $this->id);
        $stmt->bindParam(':seo_title', $this->seo_title);
        $stmt->bindParam(':seo_description', $this->seo_description);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':icon', $this->icon);
        $stmt->bindParam(':image', $this->image);
        $stmt->bindParam(':video', $this->video);
        $stmt->bindParam(':short_description', $this->short_description);
        $stmt->bindParam(':detailed_description', $this->detailed_description);
        $stmt->bindParam(':key_offerings', $this->key_offerings);
        $stmt->bindParam(':cta_text', $this->cta_text);
        $stmt->bindParam(':cta_whatsapp_message', $this->cta_whatsapp_message);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    seo_title = :seo_title,
                    seo_description = :seo_description,
                    title = :title,
                    icon = :icon,
                    image = :image,
                    video = :video,
                    short_description = :short_description,
                    detailed_description = :detailed_description,
                    key_offerings = :key_offerings,
                    cta_text = :cta_text,
                    cta_whatsapp_message = :cta_whatsapp_message
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->seo_title = htmlspecialchars(strip_tags($this->seo_title));
        $this->seo_description = htmlspecialchars(strip_tags($this->seo_description));
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->icon = htmlspecialchars(strip_tags($this->icon));
        $this->image = htmlspecialchars(strip_tags($this->image));
        $this->video = htmlspecialchars(strip_tags($this->video));
        $this->short_description = htmlspecialchars(strip_tags($this->short_description));
        $this->detailed_description = htmlspecialchars(strip_tags($this->detailed_description));
        $this->key_offerings = json_encode($this->key_offerings); // Encode JSON
        $this->cta_text = htmlspecialchars(strip_tags($this->cta_text));
        $this->cta_whatsapp_message = htmlspecialchars(strip_tags($this->cta_whatsapp_message));

        $stmt->bindParam(':seo_title', $this->seo_title);
        $stmt->bindParam(':seo_description', $this->seo_description);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':icon', $this->icon);
        $stmt->bindParam(':image', $this->image);
        $stmt->bindParam(':video', $this->video);
        $stmt->bindParam(':short_description', $this->short_description);
        $stmt->bindParam(':detailed_description', $this->detailed_description);
        $stmt->bindParam(':key_offerings', $this->key_offerings);
        $stmt->bindParam(':cta_text', $this->cta_text);
        $stmt->bindParam(':cta_whatsapp_message', $this->cta_whatsapp_message);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function delete()
    {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}

?>