<?php

class Project
{
    private $conn;
    private $table_name = "projects";

    // Propiedades del objeto
    public $id;
    public $title;
    public $client;
    public $category;
    public $service_id;
    public $cover_image;
    public $short_description;
    public $challenge;
    public $solution;
    public $outcome;
    public $technologies; // Se manejará como un array
    public $gallery;      // Se manejará como un array
    public $cta_text;
    public $cta_whatsapp_message;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function readAll()
    {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY title ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne()
    {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->id = $row['id'];
            $this->title = $row['title'];
            $this->client = $row['client'];
            $this->category = $row['category'];
            $this->service_id = $row['service_id'];
            $this->cover_image = $row['cover_image'];
            $this->short_description = $row['short_description'];
            $this->challenge = $row['challenge'];
            $this->solution = $row['solution'];
            $this->outcome = $row['outcome'];
            // Decodifica el JSON de la BD a un array de PHP
            $this->technologies = json_decode($row['technologies'], true) ?: [];
            $this->gallery = json_decode($row['gallery'], true) ?: [];
            $this->cta_text = $row['cta_text'];
            $this->cta_whatsapp_message = $row['cta_whatsapp_message'];
            return true;
        }
        return false;
    }

    public function create()
    {
        $query = "INSERT INTO " . $this->table_name . " SET id=:id, title=:title, client=:client, category=:category, service_id=:service_id, cover_image=:cover_image, short_description=:short_description, challenge=:challenge, solution=:solution, outcome=:outcome, technologies=:technologies, gallery=:gallery, cta_text=:cta_text, cta_whatsapp_message=:cta_whatsapp_message";

        $stmt = $this->conn->prepare($query);

        // Limpia y prepara los datos
        $this->sanitize();
        
        // Codifica los arrays a formato JSON para guardarlos en la BD
        $technologies_json = json_encode($this->technologies);
        $gallery_json = json_encode($this->gallery);

        // Vincula los valores a la consulta
        $stmt->bindParam(':id', $this->id);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':client', $this->client);
        $stmt->bindParam(':category', $this->category);
        $stmt->bindParam(':service_id', $this->service_id);
        $stmt->bindParam(':cover_image', $this->cover_image);
        $stmt->bindParam(':short_description', $this->short_description);
        $stmt->bindParam(':challenge', $this->challenge);
        $stmt->bindParam(':solution', $this->solution);
        $stmt->bindParam(':outcome', $this->outcome);
        $stmt->bindParam(':technologies', $technologies_json);
        $stmt->bindParam(':gallery', $gallery_json);
        $stmt->bindParam(':cta_text', $this->cta_text);
        $stmt->bindParam(':cta_whatsapp_message', $this->cta_whatsapp_message);

        return $stmt->execute();
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . " SET title=:title, client=:client, category=:category, service_id=:service_id, cover_image=:cover_image, short_description=:short_description, challenge=:challenge, solution=:solution, outcome=:outcome, technologies=:technologies, gallery=:gallery, cta_text=:cta_text, cta_whatsapp_message=:cta_whatsapp_message WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Limpia y prepara los datos
        $this->sanitize();

        // Codifica los arrays a formato JSON para guardarlos en la BD
        $technologies_json = json_encode($this->technologies);
        $gallery_json = json_encode($this->gallery);

        // Vincula los valores a la consulta
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':client', $this->client);
        $stmt->bindParam(':category', $this->category);
        $stmt->bindParam(':service_id', $this->service_id);
        $stmt->bindParam(':cover_image', $this->cover_image);
        $stmt->bindParam(':short_description', $this->short_description);
        $stmt->bindParam(':challenge', $this->challenge);
        $stmt->bindParam(':solution', $this->solution);
        $stmt->bindParam(':outcome', $this->outcome);
        $stmt->bindParam(':technologies', $technologies_json);
        $stmt->bindParam(':gallery', $gallery_json);
        $stmt->bindParam(':cta_text', $this->cta_text);
        $stmt->bindParam(':cta_whatsapp_message', $this->cta_whatsapp_message);
        
        // ¡LA LÍNEA MÁS IMPORTANTE QUE FALTABA ESTÁ AQUÍ!
        $stmt->bindParam(':id', $this->id);

        return $stmt->execute();
    }

    public function delete()
    {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $this->id = htmlspecialchars(strip_tags($this->id));
        $stmt->bindParam(1, $this->id);
        return $stmt->execute();
    }

    // Función auxiliar de limpieza para no repetir código
    private function sanitize()
    {
        $this->id = htmlspecialchars(strip_tags($this->id));
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->client = htmlspecialchars(strip_tags($this->client));
        $this->category = htmlspecialchars(strip_tags($this->category));
        $this->service_id = htmlspecialchars(strip_tags($this->service_id));
        // No sanitizamos cover_image y gallery porque son rutas generadas por nosotros, no por el usuario
        $this->short_description = htmlspecialchars(strip_tags($this->short_description));
        $this->challenge = htmlspecialchars(strip_tags($this->challenge));
        $this->solution = htmlspecialchars(strip_tags($this->solution));
        $this->outcome = htmlspecialchars(strip_tags($this->outcome));
        $this->cta_text = htmlspecialchars(strip_tags($this->cta_text));
        $this->cta_whatsapp_message = htmlspecialchars(strip_tags($this->cta_whatsapp_message));
    }
}