<?php

class Product
{
    private $conn;
    private $table_name = "products";

    public $id;
    public $title;
    public $price;
    public $short_description;
    public $ideal_for;
    public $included_modules;
    public $cta_text;
    public $cta_whatsapp_message;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function readAll()
    {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY title ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne()
    {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->title = $row['title'];
            $this->price = $row['price'];
            $this->short_description = $row['short_description'];
            $this->ideal_for = $row['ideal_for'];
            $this->included_modules = json_decode($row['included_modules'], true);
            $this->cta_text = $row['cta_text'];
            $this->cta_whatsapp_message = $row['cta_whatsapp_message'];
            return true;
        }
        return false;
    }

    public function create()
    {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    id = :id,
                    title = :title,
                    price = :price,
                    short_description = :short_description,
                    ideal_for = :ideal_for,
                    included_modules = :included_modules,
                    cta_text = :cta_text,
                    cta_whatsapp_message = :cta_whatsapp_message";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->id = htmlspecialchars(strip_tags($this->id));
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->price = htmlspecialchars(strip_tags($this->price));
        $this->short_description = htmlspecialchars(strip_tags($this->short_description));
        $this->ideal_for = htmlspecialchars(strip_tags($this->ideal_for));
        $this->included_modules = json_encode($this->included_modules); // Encode JSON
        $this->cta_text = htmlspecialchars(strip_tags($this->cta_text));
        $this->cta_whatsapp_message = htmlspecialchars(strip_tags($this->cta_whatsapp_message));

        $stmt->bindParam(':id', $this->id);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':price', $this->price);
        $stmt->bindParam(':short_description', $this->short_description);
        $stmt->bindParam(':ideal_for', $this->ideal_for);
        $stmt->bindParam(':included_modules', $this->included_modules);
        $stmt->bindParam(':cta_text', $this->cta_text);
        $stmt->bindParam(':cta_whatsapp_message', $this->cta_whatsapp_message);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    title = :title,
                    price = :price,
                    short_description = :short_description,
                    ideal_for = :ideal_for,
                    included_modules = :included_modules,
                    cta_text = :cta_text,
                    cta_whatsapp_message = :cta_whatsapp_message
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->price = htmlspecialchars(strip_tags($this->price));
        $this->short_description = htmlspecialchars(strip_tags($this->short_description));
        $this->ideal_for = htmlspecialchars(strip_tags($this->ideal_for));
        $this->included_modules = json_encode($this->included_modules); // Encode JSON
        $this->cta_text = htmlspecialchars(strip_tags($this->cta_text));
        $this->cta_whatsapp_message = htmlspecialchars(strip_tags($this->cta_whatsapp_message));

        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':price', $this->price);
        $stmt->bindParam(':short_description', $this->short_description);
        $stmt->bindParam(':ideal_for', $this->ideal_for);
        $stmt->bindParam(':included_modules', $this->included_modules);
        $stmt->bindParam(':cta_text', $this->cta_text);
        $stmt->bindParam(':cta_whatsapp_message', $this->cta_whatsapp_message);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function delete()
    {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}

?>