<?php

class Plan
{
    private $conn;
    private $table_name = "plans";

    public $id;
    public $name;
    public $price_monthly;
    public $price_annual;
    public $features;
    public $badge;
    public $highlight;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function readAll()
    {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY name ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne()
    {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->name = $row['name'];
            $this->price_monthly = $row['price_monthly'];
            $this->price_annual = $row['price_annual'];
            $this->features = json_decode($row['features'], true);
            $this->badge = $row['badge'];
            $this->highlight = $row['highlight'];
            return true;
        }
        return false;
    }

    public function create()
    {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    id = :id,
                    name = :name,
                    price_monthly = :price_monthly,
                    price_annual = :price_annual,
                    features = :features,
                    badge = :badge,
                    highlight = :highlight";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->id = htmlspecialchars(strip_tags($this->id));
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->price_monthly = $this->price_monthly === '' ? NULL : htmlspecialchars(strip_tags($this->price_monthly));
        $this->price_annual = $this->price_annual === '' ? NULL : htmlspecialchars(strip_tags($this->price_annual));
        $this->features = json_encode($this->features); // Encode JSON
        $this->badge = htmlspecialchars(strip_tags($this->badge));
        $this->highlight = (bool)$this->highlight;

        $stmt->bindParam(':id', $this->id);
        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':price_monthly', $this->price_monthly);
        $stmt->bindParam(':price_annual', $this->price_annual);
        $stmt->bindParam(':features', $this->features);
        $stmt->bindParam(':badge', $this->badge);
        $stmt->bindParam(':highlight', $this->highlight, PDO::PARAM_BOOL);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    name = :name,
                    price_monthly = :price_monthly,
                    price_annual = :price_annual,
                    features = :features,
                    badge = :badge,
                    highlight = :highlight
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->price_monthly = $this->price_monthly === '' ? NULL : htmlspecialchars(strip_tags($this->price_monthly));
        $this->price_annual = $this->price_annual === '' ? NULL : htmlspecialchars(strip_tags($this->price_annual));
        $this->features = json_encode($this->features); // Encode JSON
        $this->badge = htmlspecialchars(strip_tags($this->badge));
        $this->highlight = (bool)$this->highlight;

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':price_monthly', $this->price_monthly);
        $stmt->bindParam(':price_annual', $this->price_annual);
        $stmt->bindParam(':features', $this->features);
        $stmt->bindParam(':badge', $this->badge);
        $stmt->bindParam(':highlight', $this->highlight, PDO::PARAM_BOOL);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function delete()
    {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}

?>