<?php

class Navigation
{
    private PDO $db;
    private string $table_name = "navigation";

    public ?int $id = null;
    public ?string $name = null;
    public ?string $href = null;
    public ?int $order = null;

    public function __construct(PDO $db)
    {
        $this->db = $db;
    }

    /**
     * Lee todos los enlaces de navegación, ordenados por la columna 'order'.
     * @return PDOStatement
     */
    public function readAll(): PDOStatement
    {
        // Asegúrate de que tu tabla se llame 'navigation' y tenga la columna 'order'
        $query = "SELECT id, name, href FROM " . $this->table_name . " ORDER BY `order` ASC";
        $stmt = $this->db->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Aquí podrían ir otros métodos si decides gestionar la navegación desde el admin
}