<?php

class Career
{
    private $conn;
    private $table_name = "careers";

    public $id;
    public $title;
    public $location;
    public $type;
    public $posted_at;
    public $summary;
    public $responsibilities;
    public $requirements;
    public $benefits;
    public $process;
    public $apply_cta_text;
    public $apply_cta_whatsapp_message;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function readAll()
    {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY posted_at DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne()
    {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->title = $row['title'];
            $this->location = $row['location'];
            $this->type = $row['type'];
            $this->posted_at = $row['posted_at'];
            $this->summary = $row['summary'];
            $this->responsibilities = json_decode($row['responsibilities'], true);
            $this->requirements = json_decode($row['requirements'], true);
            $this->benefits = json_decode($row['benefits'], true);
            $this->process = json_decode($row['process'], true);
            $this->apply_cta_text = $row['apply_cta_text'];
            $this->apply_cta_whatsapp_message = $row['apply_cta_whatsapp_message'];
            return true;
        }
        return false;
    }

    public function create()
    {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    id = :id,
                    title = :title,
                    location = :location,
                    type = :type,
                    posted_at = :posted_at,
                    summary = :summary,
                    responsibilities = :responsibilities,
                    requirements = :requirements,
                    benefits = :benefits,
                    process = :process,
                    apply_cta_text = :apply_cta_text,
                    apply_cta_whatsapp_message = :apply_cta_whatsapp_message";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->id = htmlspecialchars(strip_tags($this->id));
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->location = htmlspecialchars(strip_tags($this->location));
        $this->type = htmlspecialchars(strip_tags($this->type));
        $this->posted_at = htmlspecialchars(strip_tags($this->posted_at));
        $this->summary = htmlspecialchars(strip_tags($this->summary));
        $this->responsibilities = json_encode($this->responsibilities); // Encode JSON
        $this->requirements = json_encode($this->requirements); // Encode JSON
        $this->benefits = json_encode($this->benefits); // Encode JSON
        $this->process = json_encode($this->process); // Encode JSON
        $this->apply_cta_text = htmlspecialchars(strip_tags($this->apply_cta_text));
        $this->apply_cta_whatsapp_message = htmlspecialchars(strip_tags($this->apply_cta_whatsapp_message));

        $stmt->bindParam(':id', $this->id);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':location', $this->location);
        $stmt->bindParam(':type', $this->type);
        $stmt->bindParam(':posted_at', $this->posted_at);
        $stmt->bindParam(':summary', $this->summary);
        $stmt->bindParam(':responsibilities', $this->responsibilities);
        $stmt->bindParam(':requirements', $this->requirements);
        $stmt->bindParam(':benefits', $this->benefits);
        $stmt->bindParam(':process', $this->process);
        $stmt->bindParam(':apply_cta_text', $this->apply_cta_text);
        $stmt->bindParam(':apply_cta_whatsapp_message', $this->apply_cta_whatsapp_message);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function update()
    {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    title = :title,
                    location = :location,
                    type = :type,
                    posted_at = :posted_at,
                    summary = :summary,
                    responsibilities = :responsibilities,
                    requirements = :requirements,
                    benefits = :benefits,
                    process = :process,
                    apply_cta_text = :apply_cta_text,
                    apply_cta_whatsapp_message = :apply_cta_whatsapp_message
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind values
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->location = htmlspecialchars(strip_tags($this->location));
        $this->type = htmlspecialchars(strip_tags($this->type));
        $this->posted_at = htmlspecialchars(strip_tags($this->posted_at));
        $this->summary = htmlspecialchars(strip_tags($this->summary));
        $this->responsibilities = json_encode($this->responsibilities); // Encode JSON
        $this->requirements = json_encode($this->requirements); // Encode JSON
        $this->benefits = json_encode($this->benefits); // Encode JSON
        $this->process = json_encode($this->process); // Encode JSON
        $this->apply_cta_text = htmlspecialchars(strip_tags($this->apply_cta_text));
        $this->apply_cta_whatsapp_message = htmlspecialchars(strip_tags($this->apply_cta_whatsapp_message));

        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':location', $this->location);
        $stmt->bindParam(':type', $this->type);
        $stmt->bindParam(':posted_at', $this->posted_at);
        $stmt->bindParam(':summary', $this->summary);
        $stmt->bindParam(':responsibilities', $this->responsibilities);
        $stmt->bindParam(':requirements', $this->requirements);
        $stmt->bindParam(':benefits', $this->benefits);
        $stmt->bindParam(':process', $this->process);
        $stmt->bindParam(':apply_cta_text', $this->apply_cta_text);
        $stmt->bindParam(':apply_cta_whatsapp_message', $this->apply_cta_whatsapp_message);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function delete()
    {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}

?>