<?php

require_once ROOT_PATH . '/app/models/Setting.php';

class SettingsController
{
    private $db;
    private $setting;

    public function __construct($db)
    {
        $this->db = $db;
        $this->setting = new Setting($this->db);
    }

    public function edit()
    {
        // Proteger esta ruta
        if (!isset($_SESSION['user_id'])) {
            redirect('login'); // Usando tu función redirect
            exit();
        }

        // ! CAMBIO CLAVE: Manejo de mensajes "flash" desde la sesión
        $message = null;
        if (isset($_SESSION['message'])) {
            $message = $_SESSION['message'];
            unset($_SESSION['message']); // Borrar para que no se muestre de nuevo
        }

        $error = null;
        if (isset($_SESSION['error'])) {
            $error = $_SESSION['error'];
            unset($_SESSION['error']);
        }
        
        $setting = $this->setting;
        $setting->read(); // Leer la configuración actual de la base de datos

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            
            // --- 1. PROCESAR LA SUBIDA DE LOGOS ---
            $logoUploadResult = $this->handleLogoUpload('site_logo', $setting->site_logo);
            $logoRqUploadResult = $this->handleLogoUpload('site_logo_rq', $setting->site_logo_rq);
            $logoSquareUploadResult = $this->handleLogoUpload('site_logo_square', $setting->site_logo_square);
            
            if (!$logoUploadResult['success']) {
                $error = "Error con el Logo Principal: " . $logoUploadResult['error'];
            } elseif (!$logoRqUploadResult['success']) {
                $error = "Error con el Logo RQ: " . $logoRqUploadResult['error'];
            } elseif (!$logoSquareUploadResult['success']) {
                $error = "Error con el Logo Cuadrado: " . $logoSquareUploadResult['error'];
            }

            // --- 2. SI NO HAY ERRORES, ACTUALIZAR PROPIEDADES ---
            if ($error === null) {
                // Asignar los campos de texto desde el POST
                $setting->company_name = $_POST['company_name'] ?? '';
                $setting->site_title = $_POST['site_title'] ?? '';
                $setting->site_title_template = $_POST['site_title_template'] ?? '';
                $setting->site_description = $_POST['site_description'] ?? '';
                $setting->site_url = $_POST['site_url'] ?? '';
                $setting->email = $_POST['email'] ?? '';
                $setting->phone = $_POST['phone'] ?? '';
                $setting->whatsapp_number = $_POST['whatsapp_number'] ?? '';
                $setting->address = $_POST['address'] ?? '';
                $setting->keywords = $_POST['keywords'] ?? '';
                
                if ($logoUploadResult['path'] !== null) {
                    $setting->site_logo = $logoUploadResult['path'];
                }
                if ($logoRqUploadResult['path'] !== null) {
                    $setting->site_logo_rq = $logoRqUploadResult['path'];
                }
                if ($logoSquareUploadResult['path'] !== null) {
                    $setting->site_logo_square = $logoSquareUploadResult['path'];
                }

                // --- 3. GUARDAR EN LA BASE DE DATOS ---
                if ($setting->update()) {
                    // ! CAMBIO CLAVE: Guardar mensaje en sesión y redirigir
                    $_SESSION['message'] = "¡Configuración actualizada exitosamente!";
                    redirect('admin/settings');
                    exit(); // Importante detener la ejecución después de redirigir
                } else {
                    $error = "Falló al actualizar la configuración en la base de datos.";
                }
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/settings/edit.php';
        $content = ob_get_clean();
        $pageTitle = "Ajustes del Sitio";
        require_once ROOT_PATH . '/app/views/admin/layout.php';
    }

    private function handleLogoUpload(string $fileInputName, ?string $oldImagePath = null): array
    {
        if (!isset($_FILES[$fileInputName]) || $_FILES[$fileInputName]['error'] === UPLOAD_ERR_NO_FILE) {
            return ['success' => true, 'path' => null, 'error' => null];
        }

        $file = $_FILES[$fileInputName];

        if ($file['error'] !== UPLOAD_ERR_OK) {
            return ['success' => false, 'path' => null, 'error' => 'Ocurrió un error en la subida del archivo.'];
        }

        $uploadDir = ROOT_PATH . '/public/uploads/settings/';

        if (!is_dir($uploadDir)) {
            if (!mkdir($uploadDir, 0775, true)) {
                return ['success' => false, 'path' => null, 'error' => 'Error del servidor: no se pudo crear el directorio de subida.'];
            }
        }

        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $mimeType = $finfo->file($file['tmp_name']);
        $allowedMimeTypes = ['image/jpeg', 'image/png', 'image/webp', 'image/svg+xml'];

        if (!in_array($mimeType, $allowedMimeTypes)) {
            return ['success' => false, 'path' => null, 'error' => 'Formato no permitido. Sube solo imágenes JPG, PNG, WebP o SVG.'];
        }
        
        $fileExtension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if ($mimeType === 'image/svg+xml' && $fileExtension === '') {
            $fileExtension = 'svg';
        }
        $newFileName = uniqid('setting_', true) . '.' . $fileExtension;
        $destPath = $uploadDir . $newFileName;

        if (!move_uploaded_file($file['tmp_name'], $destPath)) {
             return ['success' => false, 'path' => null, 'error' => 'No se pudo mover el archivo subido.'];
        }

        if ($oldImagePath && file_exists(ROOT_PATH . '/public' . $oldImagePath)) {
            @unlink(ROOT_PATH . '/public' . $oldImagePath);
        }

        return ['success' => true, 'path' => '/uploads/settings/' . $newFileName, 'error' => null];
    }
}