<?php

require_once ROOT_PATH . '/app/models/Recognition.php';

class RecognitionController
{
    private PDO $db;
    private Recognition $recognition;

    public function __construct(PDO $db)
    {
        $this->db = $db;
        $this->recognition = new Recognition($this->db);
    }

    public function index(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        $recognitions = $this->recognition->readAll()->fetchAll(PDO::FETCH_ASSOC);
        ob_start();
        require_once ROOT_PATH . '/app/views/admin/recognitions/index.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Gestionar Reconocimientos");
    }

    public function create(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        $error = null;
        $recognitionData = [];

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $recognitionData = $_POST;
            $this->recognition->title = $_POST['title'] ?? '';
            $this->recognition->issuer = $_POST['issuer'] ?? '';
            $this->recognition->icon = $_POST['icon'] ?? '';

            if ($this->recognition->create()) {
                $_SESSION['message'] = "¡Reconocimiento creado exitosamente!";
                redirect('admin/recognitions');
            } else {
                $error = "Falló al crear el reconocimiento.";
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/recognitions/create.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Crear Nuevo Reconocimiento");
    }

    public function edit(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        $error = null;
        $this->recognition->id = $_GET['id'] ?? 0;

        if (!$this->recognition->readOne()) {
            $_SESSION['error'] = "Reconocimiento no encontrado.";
            redirect('admin/recognitions');
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->recognition->id = $_POST['id'];
            $this->recognition->title = $_POST['title'] ?? '';
            $this->recognition->issuer = $_POST['issuer'] ?? '';
            $this->recognition->icon = $_POST['icon'] ?? '';

            if ($this->recognition->update()) {
                $_SESSION['message'] = "¡Reconocimiento actualizado exitosamente!";
                redirect('admin/recognitions');
            } else {
                $error = "Falló al actualizar el reconocimiento.";
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/recognitions/edit.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Editar Reconocimiento");
    }

    public function delete(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->recognition->id = $_POST['id'] ?? 0;
            if ($this->recognition->delete()) {
                $_SESSION['message'] = "¡Reconocimiento eliminado exitosamente!";
            } else {
                $_SESSION['error'] = "Falló al eliminar el reconocimiento.";
            }
        }
        redirect('admin/recognitions');
    }

    private function renderAdminLayout(string $content, string $pageTitle): void
    {
        ob_start();
        echo $content;
        $content = ob_get_clean();
        require_once ROOT_PATH . '/app/views/admin/layout.php';
    }
}