<?php

require_once ROOT_PATH . '/app/models/Plan.php';

class PlanController
{
    private $db;
    private $plan;

    public function __construct($db)
    {
        $this->db = $db;
        $this->plan = new Plan($this->db);
    }

    private function renderAdminLayout($content, $pageTitle)
    {
        ob_start();
        echo $content;
        $content = ob_get_clean();
        require_once ROOT_PATH . '/app/views/admin/layout.php';
    }

    public function index()
    {
        if (!isset($_SESSION['user_id'])) {
            redirect('login');
        }

        $stmt = $this->plan->readAll();
        $plans = $stmt->fetchAll(PDO::FETCH_ASSOC);

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/plans/index.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Gestionar Planes");
    }

    public function create()
    {
        if (!isset($_SESSION['user_id'])) {
            redirect('login');
        }
        $error = null;

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->plan->id = $_POST['id'] ?? '';
            $this->plan->name = $_POST['name'] ?? '';
            $this->plan->badge = $_POST['badge'] ?? '';

            // Asigna NULL si el campo está vacío, de lo contrario, el valor
            $this->plan->price_monthly = !empty($_POST['price_monthly']) ? $_POST['price_monthly'] : NULL;
            $this->plan->price_annual = !empty($_POST['price_annual']) ? $_POST['price_annual'] : NULL;

            // Procesa el checkbox 'highlight'
            $this->plan->highlight = isset($_POST['highlight']) ? 1 : 0;
            
            // Procesa las 'features' de un string con saltos de línea a un array JSON
            $features_string = $_POST['features'] ?? '';
            $features_array = array_filter(array_map('trim', explode("\n", $features_string)));
            $this->plan->features = json_encode(array_values($features_array));

            if ($this->plan->create()) {
                $_SESSION['message'] = "¡Plan creado exitosamente!";
                redirect('admin/plans');
            } else {
                $error = "Falló al crear el plan. Verifica que el ID no esté repetido.";
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/plans/create.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Crear Nuevo Plan");
    }

     public function edit()
    {
        if (!isset($_SESSION['user_id'])) {
            redirect('login');
        }
        $error = null;

        // --- CORRECCIÓN CLAVE ---
        // 1. Obtenemos el ID de la fuente correcta: POST si se envía el formulario, GET si se carga la página.
        $id = $_POST['id'] ?? $_GET['id'] ?? null;

        if (!$id) {
            $_SESSION['error'] = "No se especificó un ID de plan.";
            redirect('admin/plans');
        }

        $this->plan->id = $id;

        // 2. Cargamos los datos del plan ANTES de cualquier otra lógica.
        if (!$this->plan->readOne()) {
            $_SESSION['error'] = "Plan no encontrado.";
            redirect('admin/plans');
        }

        // 3. Si es una solicitud POST, procesamos los datos del formulario.
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // El ID ya está asignado al objeto, ahora solo actualizamos el resto de los campos.
            $this->plan->name = $_POST['name'] ?? '';
            $this->plan->badge = $_POST['badge'] ?? '';
            $this->plan->price_monthly = !empty($_POST['price_monthly']) ? $_POST['price_monthly'] : NULL;
            $this->plan->price_annual = !empty($_POST['price_annual']) ? $_POST['price_annual'] : NULL;
            $this->plan->highlight = isset($_POST['highlight']) ? 1 : 0;
            
            $features_string = $_POST['features'] ?? '';
            $features_array = array_filter(array_map('trim', explode("\n", $features_string)));
            $this->plan->features = json_encode(array_values($features_array));

            // 4. Intentamos actualizar la base de datos.
            if ($this->plan->update()) {
                $_SESSION['message'] = "¡Plan actualizado exitosamente!";
                redirect('admin/plans');
            } else {
                $error = "Falló al actualizar el plan.";
            }
        }

        // 5. Preparamos los datos para la vista (decodificar JSON para el textarea)
        if (!is_array($this->plan->features)) {
            $this->plan->features = json_decode($this->plan->features, true) ?? [];
        }
        
        // 6. Renderizamos la vista con los datos cargados o el error.
        ob_start();
        require_once ROOT_PATH . '/app/views/admin/plans/edit.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Editar Plan");
    }

    public function delete()
    {
        if (!isset($_SESSION['user_id'])) {
            redirect('login');
        }

        // Borrado seguro usando POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->plan->id = $_POST['id'] ?? '';
            if ($this->plan->delete()) {
                $_SESSION['message'] = "¡Plan eliminado exitosamente!";
            } else {
                $_SESSION['error'] = "Falló al eliminar el plan.";
            }
        } else {
            $_SESSION['error'] = "Acción no permitida.";
        }
        
        redirect('admin/plans');
    }
}