<?php

require_once ROOT_PATH . '/app/models/Industry.php';

class IndustryController
{
    private PDO $db;
    private Industry $industry;

    public function __construct(PDO $db)
    {
        $this->db = $db;
        $this->industry = new Industry($this->db);
    }

    public function index(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        $industries = $this->industry->readAll()->fetchAll(PDO::FETCH_ASSOC);
        ob_start();
        require_once ROOT_PATH . '/app/views/admin/industries/index.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Gestionar Industrias");
    }

    public function create(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        $error = null;
        $industryData = [];

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $industryData = $_POST;
            $this->industry->name = $_POST['name'] ?? '';

            if ($this->industry->create()) {
                $_SESSION['message'] = "¡Industria creada exitosamente!";
                redirect('admin/industries');
            } else {
                $error = "Falló al crear la industria.";
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/industries/create.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Crear Nueva Industria");
    }

    public function edit(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        $error = null;
        $this->industry->id = $_GET['id'] ?? 0;

        if (!$this->industry->readOne()) {
            $_SESSION['error'] = "Industria no encontrada.";
            redirect('admin/industries');
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->industry->id = $_POST['id'];
            $this->industry->name = $_POST['name'] ?? '';

            if ($this->industry->update()) {
                $_SESSION['message'] = "¡Industria actualizada exitosamente!";
                redirect('admin/industries');
            } else {
                $error = "Falló al actualizar la industria.";
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/industries/edit.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Editar Industria");
    }

    public function delete(): void
    {
        if (!isset($_SESSION['user_id'])) { redirect('login'); }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->industry->id = $_POST['id'] ?? 0;
            if ($this->industry->delete()) {
                $_SESSION['message'] = "¡Industria eliminada exitosamente!";
            } else {
                $_SESSION['error'] = "Falló al eliminar la industria.";
            }
        }
        redirect('admin/industries');
    }

    private function renderAdminLayout(string $content, string $pageTitle): void
    {
        ob_start();
        echo $content;
        $content = ob_get_clean();
        require_once ROOT_PATH . '/app/views/admin/layout.php';
    }
}