<?php

require_once ROOT_PATH . '/app/models/Career.php';

class CareerController
{
    private $db;
    private $career;

    public function __construct($db)
    {
        $this->db = $db;
        $this->career = new Career($this->db);
    }

    private function renderAdminLayout($content, $pageTitle)
    {
        ob_start();
        echo $content; // Render the specific view content
        $content = ob_get_clean();
        require_once ROOT_PATH . '/app/views/admin/layout.php';
    }

    public function index()
    {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }

        $stmt = $this->career->readAll();
        $careers = $stmt->fetchAll(PDO::FETCH_ASSOC);

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/careers/index.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Manage Careers");
    }

    public function create()
    {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->career->id = $_POST['id'] ?? '';
            $this->career->title = $_POST['title'] ?? '';
            $this->career->location = $_POST['location'] ?? '';
            $this->career->type = $_POST['type'] ?? '';
            $this->career->posted_at = $_POST['posted_at'] ?? '';
            $this->career->summary = $_POST['summary'] ?? '';
            $this->career->responsibilities = isset($_POST['responsibilities']) ? explode("\n", $_POST['responsibilities']) : [];
            $this->career->requirements = isset($_POST['requirements']) ? explode("\n", $_POST['requirements']) : [];
            $this->career->benefits = isset($_POST['benefits']) ? explode("\n", $_POST['benefits']) : [];
            $this->career->process = isset($_POST['process']) ? explode("\n", $_POST['process']) : [];
            $this->career->apply_cta_text = $_POST['apply_cta_text'] ?? '';
            $this->career->apply_cta_whatsapp_message = $_POST['apply_cta_whatsapp_message'] ?? '';

            if ($this->career->create()) {
                $_SESSION['message'] = "Career created successfully!";
                header('Location: /admin/careers');
                exit();
            } else {
                $error = "Failed to create career.";
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/careers/create.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Create Career");
    }

    public function edit()
    {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }

        $this->career->id = $_GET['id'] ?? '';
        if (!$this->career->readOne()) {
            $_SESSION['error'] = "Career not found.";
            header('Location: /admin/careers');
            exit();
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->career->title = $_POST['title'] ?? '';
            $this->career->location = $_POST['location'] ?? '';
            $this->career->type = $_POST['type'] ?? '';
            $this->career->posted_at = $_POST['posted_at'] ?? '';
            $this->career->summary = $_POST['summary'] ?? '';
            $this->career->responsibilities = isset($_POST['responsibilities']) ? explode("\n", $_POST['responsibilities']) : [];
            $this->career->requirements = isset($_POST['requirements']) ? explode("\n", $_POST['requirements']) : [];
            $this->career->benefits = isset($_POST['benefits']) ? explode("\n", $_POST['benefits']) : [];
            $this->career->process = isset($_POST['process']) ? explode("\n", $_POST['process']) : [];
            $this->career->apply_cta_text = $_POST['apply_cta_text'] ?? '';
            $this->career->apply_cta_whatsapp_message = $_POST['apply_cta_whatsapp_message'] ?? '';

            if ($this->career->update()) {
                $_SESSION['message'] = "Career updated successfully!";
                header('Location: /admin/careers');
                exit();
            } else {
                $error = "Failed to update career.";
            }
        }

        ob_start();
        require_once ROOT_PATH . '/app/views/admin/careers/edit.php';
        $content = ob_get_clean();
        $this->renderAdminLayout($content, "Edit Career");
    }

    public function delete()
    {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }

        $this->career->id = $_GET['id'] ?? '';
        if ($this->career->delete()) {
            $_SESSION['message'] = "Career deleted successfully!";
        } else {
            $_SESSION['error'] = "Failed to delete career.";
        }
        header('Location: /admin/careers');
        exit();
    }
}

?>