<?php

require_once ROOT_PATH . '/app/models/User.php';

class AuthController
{
    private $db;
    private $user;

  public function __construct($db) // <-- Acepta la conexión aquí
    {
        // Ya no necesitas crear la conexión, solo asignarla.
        $this->db = $db;
        $this->user = new User($this->db);
    }

    public function showLoginForm()
    {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        if (isset($_SESSION['user_id'])) {
            redirect('admin/dashboard');
        }
        require_once ROOT_PATH . '/app/views/auth/login.php';
    }

    public function login()
    {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            $error = null;

            if ($this->user->findByUsername($username)) {
                if (password_verify($password, $this->user->password)) {
                    // Credenciales correctas: guardar sesión y redirigir
                    $_SESSION['user_id'] = $this->user->id;
                    $_SESSION['username'] = $this->user->username;
                    $_SESSION['role'] = $this->user->role;
                    redirect('admin/dashboard');
                } else {
                    // Contraseña incorrecta
                    $error = "Usuario o contraseña inválidos.";
                }
            } else {
                // Usuario no encontrado
                $error = "Usuario o contraseña inválidos.";
            }
            
            // Si hubo un error, la ejecución continúa aquí.
            // Volvemos a cargar la vista del login, que ahora tendrá acceso a la variable $error.
            require_once ROOT_PATH . '/app/views/auth/login.php';
        }
    }

    public function logout()
    {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        session_unset();
        session_destroy();
        redirect('login');
    }
}

